% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse.item.R
\name{reverse.item}
\alias{reverse.item}
\title{Reverse Code Scale Item}
\usage{
reverse.item(x, min = NULL, max = NULL, keep = NULL, as.na = NULL, table = FALSE,
             check = TRUE)
}
\arguments{
\item{x}{a numeric vector with integer values.}

\item{min}{an integer indicating the minimum of the item (i.e., lowest possible scale value).}

\item{max}{an integer indicating the maximum of the item (i.e., highest possible scale value).}

\item{keep}{a numeric vector indicating values not to be reverse coded.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.}

\item{table}{logical: if \code{TRUE}, a cross table item x reverse coded item is printed
on the console.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\value{
Returns a numeric vector with the same length as \code{x} containing the reverse coded scale item.
}
\description{
This function reverse codes an inverted item, i.e., item that is negatively worded.
}
\details{
If arguments \code{min} and/or \code{max} are not specified, empirical minimum and/or maximum is computed
from the vector. Note, however, that reverse coding might fail if the lowest or highest possible scale value
is not represented in the vector. That is, it is always preferable to specify the arguments \code{min} and
\code{max}.
}
\examples{
dat <- data.frame(item1 = c(5, 2, 3, 4, 1, 2, 4, 2),
                  item2 = c(1, 5, 3, 1, 4, 4, 1, 5),
                  item3 = c(4, 2, 4, 5, 1, 3, 5, -99))

# Reverse code item2
reverse.item(dat$item2, min = 1, max = 5)

# Reverse code item3 while keeping the value -99
reverse.item(dat$item3, min = 1, max = 5, keep = -99)

# Reverse code item3 while keeping the value -99 and check recoding
dat$item3r <- reverse.item(dat$item3, min = 1, max = 5, keep = -99, table = TRUE)
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
New York: John Wiley & Sons.
}
\seealso{
\code{\link{alpha.coef}}, \code{\link{rec}}, \code{\link{scores}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
