% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{Distribution_autoplot}
\alias{Distribution_autoplot}
\alias{plot.compdist}
\alias{plot.trans_compdist}
\alias{plot.contdist}
\alias{plot.trans_contdist}
\alias{plot.discrdist}
\alias{plot.trans_discrdist}
\alias{plot.contmixdist}
\alias{plot.trans_contmixdist}
\alias{plot.discrmixdist}
\alias{plot.trans_discrmixdist}
\alias{plot.contdiscrmixdist}
\alias{plot.trans_contdiscrmixdist}
\title{Autoplot of Distributions}
\usage{
\method{plot}{compdist}(x, which = "all", only_mix = FALSE, pp1 = 1000, pp2 = 1000, col = "#122e94",
        xlim1 = q(x, c(0.01, 0.99)), ylim1 = NULL, xlim2 = xlim1, ylim2 = NULL,
        xlab1 = "x", ylab1 = "P(X \u2264 x)", xlab2 = "x", ylab2 = "P(X = x)",
        main1 = "CDF", main2 = "PDF", type1 = "l", type2 = "l",
        lty1 = 1, lty2 = 1, lwd1 = 2, lwd2 = 2, lty_abline = 3, mtext_cex = 1, ...)

\method{plot}{trans_compdist}(x, which = "all", only_mix = FALSE, pp1 = 1000, pp2 = 1000, col = "#122e94",
        xlim1 = q(x, c(0.01, 0.99)), ylim1 = NULL, xlim2 = xlim1, ylim2 = NULL,
        xlab1 = "x", ylab1 = "P(X \u2264 x)", xlab2 = "x", ylab2 = "P(X = x)",
        main1 = "CDF", main2 = "PDF", type1 = "l", type2 = "l",
        lty1 = 1, lty2 = 1, lwd1 = 2, lwd2 = 2, lty_abline = 3, mtext_cex = 1, ...)

\method{plot}{contdist}(x, which = "all", pp1 = 1000, pp2 = 1000, col = "#122e94",
        xlim1 = q(x, c(0.01, 0.99)), ylim1 = NULL, xlim2 = xlim1, ylim2 = NULL,
        xlab1 = "x", ylab1 = "P(X \u2264 x)", xlab2 = "x", ylab2 = "P(X = x)",
        main1 = "CDF", main2 = "PDF", type1 = "l", type2 = "l",
        lty1 = NULL, lty2 = NULL, lwd1 = NULL, lwd2 = NULL, ...)

\method{plot}{trans_contdist}(x, which = "all", pp1 = 1000, pp2 = 1000, col = "#122e94",
        xlim1 = q(x, c(0.01, 0.99)), ylim1 = NULL, xlim2 = xlim1, ylim2 = NULL,
        xlab1 = "x", ylab1 = "P(X \u2264 x)", xlab2 = "x", ylab2 = "P(X = x)",
        main1 = "CDF", main2 = "PDF", type1 = "l", type2 = "l",
        lty1 = NULL, lty2 = NULL, lwd1 = NULL, lwd2 = NULL, ...)

\method{plot}{discrdist}(x, which = "all", col = "#122e94",
        xlim1 = q(x,c(0.01, 0.99)), ylim1 = NULL, xlim2 = xlim1, ylim2 = NULL,
        xlab1 = "x", ylab1 = "P(X \u2264 x)", xlab2 = "x", ylab2 = "P(X = x)",
        main1 = "CDF", main2 = "PMF", type1 = NULL, type2 = NULL,
        lty1 = NULL, lty2 = NULL, lwd1 = NULL, lwd2 = NULL, ...)

\method{plot}{trans_discrdist}(x, which = "all", col = "#122e94",
        xlim1 = q(x, c(0.01, 0.99)), ylim1 = NULL, xlim2 = xlim1, ylim2 = NULL,
        xlab1 = "x", ylab1 = "P(X \u2264 x)", xlab2 = "x", ylab2 = "P(X = x)",
        main1 = "CDF", main2 = "PMF", type1 = "p", type2 = "p",
        lty1 = NULL, lty2 = NULL, lwd1 = NULL, lwd2 = NULL, ...)

\method{plot}{contmixdist}(x, which = "all", only_mix = FALSE, pp1 = 1000, pp2 = 1000, col = "#122e94",
        xlim1 = q(x, c(0.01, 0.99)), ylim1 = NULL, xlim2 = xlim1, ylim2 = NULL,
        xlab1 = "x", ylab1 = "P(X \u2264 x)", xlab2 = "x", ylab2 = "P(X = x)",
        main1 = "CDF", main2 = "PDF", type1 = "l", type2 = "l",
        lty1 = 3, lty2 = 3, lwd1 = 2, lwd2 = 2, ...)

\method{plot}{trans_contmixdist}(x, which = "all", only_mix = FALSE, pp1 = 1000, pp2 = 1000, col = "#122e94",
        xlim1 = q(x, c(0.01, 0.99)), ylim1 = NULL, xlim2 = xlim1, ylim2 = NULL,
        xlab1 = "x", ylab1 = "P(X \u2264 x)", xlab2 = "x", ylab2 = "P(X = x)",
        main1 = "CDF", main2 = "PDF", type1 = "l", type2 = "l",
        lty1 = 3, lty2 = 3, lwd1 = 2, lwd2 = 2, ...)

\method{plot}{discrmixdist}(x, which = "all", only_mix = FALSE,
        pp1 = 1000, pp2 = 2 * (diff(xlim2)), col = "#122e94",
        xlim1 = q(x,c(0.01, 0.99)), ylim1 = c(0, 1), xlim2 = xlim1, ylim2 = NULL,
        xlab1 = "x", ylab1 = "P(X \u2264 x)", xlab2 = "x", ylab2 = "P(X = x)",
        main1 = "CDF", main2 = "PMF", type1 = "l", type2 = "l",
        lty1 = 3, lty2 = 3, lwd1 = 3, lwd2 = 3, ...)

\method{plot}{trans_discrmixdist}(x, which = "all", only_mix = FALSE,
        pp1 = 1000, pp2 = 2 * (diff(xlim2)), col = "#122e94",
        xlim1 = q(x,c(0.01, 0.99)), ylim1 = c(0, 1), xlim2 = xlim1, ylim2 = NULL,
        xlab1 = "x", ylab1 = "P(X \u2264 x)", xlab2 = "x", ylab2 = "P(X = x)",
        main1 = "CDF", main2 = "PMF", type1 = "l", type2 = "l",
        lty1 = 3, lty2 = 3, lwd1 = 3, lwd2 = 3, ...)

\method{plot}{contdiscrmixdist}(x, which = "all", only_mix = FALSE, pp1 = 1000, pp2 = 1000, col = "#122e94",
        xlim1 = q(x, c(0.01, 0.99)), ylim1 = c(0, 1), xlim2 = xlim1, ylim2 = NULL,
        xlab1 = "x", ylab1 = "P(X \u2264 x)", xlab2 = "x", ylab2 = "P(X = x)",
        main1 = "CDF", main2 = "PDF", type1 = "l", type2 = "l",
        lty1 = 3, lty2 = 3, lwd1 = 2, lwd2 = 2, ...)

\method{plot}{trans_contdiscrmixdist}(x, which = "all", only_mix = FALSE, pp1 = 1000, pp2 = 1000, col = "#122e94",
        xlim1 = q(x, c(0.01, 0.99)), ylim1 = c(0, 1), xlim2 = xlim1, ylim2 = NULL,
        xlab1 = "x", ylab1 = "P(X \u2264 x)", xlab2 = "x", ylab2 = "P(X = x)",
        main1 = "CDF", main2 = "PDF", type1 = "l", type2 = "l",
        lty1 = 3, lty2 = 3, lwd1 = 2, lwd2 = 2, ...)
}
\arguments{
\item{x}{distribution object.}

\item{which}{whether to plot only CDF, PDF or both, default: 'all'.}

\item{only_mix}{whether to plot only mixture/composite model and not also the components, default: FALSE.}

\item{pp1}{number of points at which CDF is evaluated, default: 1000.}

\item{pp2}{number of points at which PDF is evaluated, default: 1000.}

\item{col}{color used in plot, default: '#122e94'.}

\item{xlim1}{xlim of CDF plot, default: q(x, c(0.01, 0.99)).}

\item{ylim1}{ylim of CDF plot, default: NULL.}

\item{xlim2}{xlim of PDF plot, default: xlim1.}

\item{ylim2}{ylim of PDF plot, default: NULL.}

\item{xlab1}{xlab of CDF plot, default: 'x'.}

\item{ylab1}{ylab of CDF plot, default: 'P(X <U+2264> x)'.}

\item{xlab2}{xlab of PDF plot, default: 'x'.}

\item{ylab2}{ylab of PDF plot, default: 'P(X = x)'.}

\item{main1}{title of CDF plot, default: 'CDF'.}

\item{main2}{title of PDF plot, default: 'PDF'/'PMF'.}

\item{type1}{type of CDF plot.}

\item{type2}{type of PDF plot.}

\item{lty1}{lty used in CDF plot.}

\item{lty2}{lty used in PDF plot.}

\item{lwd1}{lwd used in CDF plot.}

\item{lwd2}{lwd used in PDF plot.}

\item{lty_abline}{lty of abline if ablines are part of plot (composite and discrete distributions).}

\item{mtext_cex}{cex parameter for mtexts used in the plots of composite distributions, default: 1.}

\item{...}{further arguments to be passed.}
}
\description{
The functions plot the CDF and PDF of a given distribution object.
}
\examples{
N <- normdist()
plot(N)

# manipulating cdf plot
B <- binomdist(12, 0.5)
plot(-3*B, which = "cdf", xlim1 = c(-30, -10))
# manipulating pdf plot
plot(-3*B, which = "pdf", xlim1 = c(-30, -10))
}
