% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trafo.R
\name{sudo_support}
\alias{sudo_support}
\alias{sudo_support.discrdist}
\alias{sudo_support.contdist}
\alias{sudo_support.mixdist}
\alias{sudo_support.compdist}
\alias{sudo_support.trans_univdist}
\title{Support Interval of Distribution Object}
\usage{
sudo_support(O)

\method{sudo_support}{discrdist}(O)

\method{sudo_support}{contdist}(O)

\method{sudo_support}{mixdist}(O)

\method{sudo_support}{compdist}(O)

\method{sudo_support}{trans_univdist}(O)
}
\arguments{
\item{O}{distribution object.}
}
\value{
Named vector containing two values.
}
\description{
\code{sudo_support} is a generic function that returns the two boundary values
              of object's support.
}
\details{
Methods of \code{sudo_support} function calculate the support's boundary
         values for any distribution in the package \code{\link{mistr}}. This technique
         is particularly useful when dealing with a transformed distribution.
}
\examples{
B  <- binomdist(10, 0.3)
sudo_support(B)

B2 <- -3*log(B)
sudo_support(B2)

sudo_support( mixdist(B2, normdist(), weights = c(0.5, 0.5)))
}
