% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{autoplot.comp_fit}
\alias{autoplot.comp_fit}
\title{Autoplot of Fitted Distributions Using ggplot2}
\usage{
autoplot.comp_fit(x, which = "all", layout = matrix(c(1, 2, 1, 3), nrow
  = 2), empir_color = "#F9D607", empir_alpha = 0.4, ...)
}
\arguments{
\item{x}{distribution object.}

\item{which}{whether to plot only CDF, PDF, qq  or all three, default: 'all'.}

\item{layout}{layout of plots, default: matrix(c(1, 2, 1, 3), nrow = 2).}

\item{empir_color}{color of empirical data, default: '#F9D607'.}

\item{empir_alpha}{alpha of empirical data, default: 0.4.}

\item{...}{further arguments to be passed.}
}
\value{
ggplot object if \code{which = "cdf"} or \code{which = "pdf"} or \code{which = "qq"}.
        If all are plotted, the plots are merged using \code{multiplot()} function and a list with all plots is invisibly returned.
}
\description{
The functions plot the CDF, PDF and QQ-plot of a fitted distribution object together with the empirical values.
}
\seealso{
\code{\link{plotgg}}
}
