% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/averageMI.R
\name{averageMI}
\alias{averageMI}
\title{Collapse values from multiple imputation draws}
\usage{
averageMI(par, SEpar, as.data.frame = TRUE, digits = 4)
}
\arguments{
\item{par}{a list containing parameter estimates which were computed the imputed datasets}

\item{SEpar}{a list containing standard errors associated with \code{par}}

\item{as.data.frame}{logical; return a data.frame instead of a list? Default is TRUE}

\item{digits}{number of digits to round result. Default is 4}
}
\value{
returns a list or data.frame containing the updated averaged parameter estimates,
  standard errors, and t-values with the associated degrees of freedom and two tailed p-values
}
\description{
This function computes updated parameter and standard error estimates using multiple
imputation methodology. Given a set of parameter estimates and their associated standard
errors the function returns the weighted average of the overall between and within
variability due to the multiple imputations according to Rubin's (1987) methodology.
}
\examples{
\dontrun{

#simulate data
set.seed(1234)
N <- 1000

# covariates
X1 <- rnorm(N); X2 <- rnorm(N)
covdata <- data.frame(X1, X2)
Theta <- matrix(0.5 * X1 + -1 * X2 + rnorm(N, sd = 0.5))

#items and response data
a <- matrix(1, 20); d <- matrix(rnorm(20))
dat <- simdata(a, d, 1000, itemtype = 'dich', Theta=Theta)

mod1 <- mirt(dat, 1, 'Rasch', covdata=covdata, formula = ~ X1 + X2)
coef(mod1, simplify=TRUE)

#draw plausible values for secondary analyses
pv <- fscores(mod1, plausible.draws = 10)
pvmods <- lapply(pv, function(x, covdata) lm(x ~ covdata$X1 + covdata$X2),
                 covdata=covdata)

# compute Rubin's multiple imputation average
so <- lapply(pvmods, summary)
par <- lapply(so, function(x) x$coefficients[, 'Estimate'])
SEpar <- lapply(so, function(x) x$coefficients[, 'Std. Error'])
averageMI(par, SEpar)

}
}
\references{
Rubin, D.B. (1987) Multiple Imputation for Nonresponse in Surveys. Wiley & Sons, New York.
}
\keyword{imputation}
\keyword{multiple}

