% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{stop_mirai}
\alias{stop_mirai}
\title{mirai (Stop)}
\usage{
stop_mirai(x)
}
\arguments{
\item{x}{a \sQuote{mirai} object, or list of \sQuote{mirai} objects.}
}
\value{
Logical \code{TRUE} if the cancellation request was successful (was
  awaiting execution or in execution), or else \code{FALSE} (if already
  completed or previously cancelled). Will always return \code{FALSE} if not
  using dispatcher.

  Or a vector of logical values if supplying a list of \sQuote{mirai}, such
  as those returned by \code{\link{mirai_map}}.
}
\description{
Stops a \sQuote{mirai} if still in progress, causing it to resolve
immediately to an \sQuote{errorValue} 20 (Operation canceled).
}
\details{
Using dispatcher allows cancellation of \sQuote{mirai}. In the case that the
\sQuote{mirai} is awaiting execution, it is discarded from the queue and
never evaluated. In the case it is already in execution, an interrupt will be
sent.

A successful cancellation request does not guarantee successful cancellation:
the task, or a portion of it, may have already completed before the interrupt
is received. Even then, compiled code is not always interruptible. This
should be noted, particularly if the code carries out side effects during
execution, such as writing to files, etc.
}
\examples{
if (interactive()) {
# Only run examples in interactive R sessions

m <- mirai(Sys.sleep(n), n = 5)
stop_mirai(m)
m$data

}

}
