if(interactive()) {library(testthat); Sys.setenv(NOT_CRAN="true")}

context("makeRepo")


revolution <- c(CRAN="http://mran.revolutionanalytics.com/snapshot/2014-10-15")
pkgs <- c("Bmix")
repo_root <- file.path(tempdir(), "miniCRAN", Sys.Date())
if(file.exists(repo_root)) unlink(repo_root, recursive = TRUE)

# list.files(repo_root, recursive = TRUE)


types <- c("source", "win.binary", "mac.binary", "mac.binary.mavericks")
names(types) <- c("source", "win.binary", "mac.binary", "mac.binary")

for(pkg_type in names(types)){  
  
  test_that(sprintf("makeRepo downloads %s files and builds PACKAGES file", pkg_type), {
    
    skip_on_cran()
    
    pdb <- pkgAvail(repos = revolution, type=pkg_type)
    pkgList <- pkgDep(pkgs, availPkgs = pdb, repos=revolution, type=pkg_type, suggests=FALSE)
    prefix <- miniCRAN:::repoPrefix(pkg_type, R.version)
    dir.create(repo_root, recursive = TRUE, showWarnings = FALSE)
    
    makeRepo(pkgList, path=repo_root, repos=revolution, type=pkg_type, quiet=TRUE)
    
    expect_true(
      miniCRAN:::.checkForRepoFiles(repo_root, pkgList, prefix)
    )
    expect_true(
      file.exists(file.path(repo_root, prefix, "PACKAGES.gz"))
    )
    expect_true(
      all(
        pkgList %in% pkgAvail(repos = repo_root, type=pkg_type)[, "Package"]
      )
    )
    
  })
  
}



unlink(repo_root, recursive = TRUE)

