#' One-mode EU policy influence network, June 2004
#'
#' Network of anonymised actors reacting to the Ryanair/Charleroi decision of
#' the EU Commission in February 2004.
#' The relationships mapped comprise an account of public records of interaction
#' supplemented with the cognitive network of key informants.
#' Examination of relevant communiques, public statements and a number of
#' off-the-record interviews provides confidence
#' that the network mapped closely approximated interactions between 29 January
#' and 12 February 2004. The time point mapped is at the height of influence and
#' interest intermediation played by actors in the AER,
#' a comparatively obscure body representing the interests of a number of
#' European regional bodies at the EU institutions.
#'
#' @docType data
#' @keywords datasets
#' @name mpn_ryanair
#' @usage data(mpn_ryanair)
#' @format Matrix with 20 rows/columns
#' @source Christopoulos, Dimitrios C. 2006.
#' “Relational Attributes of Political Entrepreneurs: a Network Perspective.”
#' \emph{Journal of European Public Policy} 13 (5): 757–78.
#' 
#' Knoke, Diani, Hollway, and Christopoulos. 2021. \emph{Multimodal Political Networks}. Cambridge University Press: Cambridge.
"mpn_ryanair"
