#' One-mode Mexican power elite database
#'
#' A network of 11 core members of the 1990s Mexican power elite (Knoke 2017), 
#' three of which were successively elected presidents of Mexico: 
#' José López Portillo (1976-82), Miguel de la Madrid (1982-88), and Carlos Salinas de Gortari (1988-94, 
#' who was also the son of another core member, Raúl Salinas Lozano). 
#' The undirected lines connecting pairs of men represent any formal, informal, 
#' or organizational relation between a dyad; 
#' for example, “common belonging (school, sports, business, political participation), 
#' or a common interest (political power)” (Mendieta et al. 1997: 37). 
#'
#' @docType data
#' @keywords datasets
#' @name mpn_elite_mex
#' @usage data(mpn_elite_mex)
#' @format Matrix with 11 rows/columns
#' @source Knoke, David. 1990. \emph{Political Networks}. 
#' 
#' Knoke, David, Mario Diani, James Hollway, and Dimitris C Christopoulos. 2021. 
#' \href{https://www.cambridge.org/core/books/multimodal-political-networks/43EE8C192A1B0DCD65B4D9B9A7842128}{\emph{Multimodal Political Networks}}. 
#' Cambridge University Press. Cambridge University Press.
"mpn_elite_mex"
