% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elliptical.R
\name{rtellipt}
\alias{rtellipt}
\title{Simulate elliptical vector subject to a linear constraint}
\usage{
rtellipt(n, beta, mu, sigma, df, delta = 0)
}
\arguments{
\item{n}{number of simulations}

\item{beta}{\code{d} vector of linear constraints}

\item{mu}{location vector}

\item{sigma}{scale matrix}

\item{df}{degrees of freedom argument}

\item{delta}{buffer; default to zero}
}
\value{
an \code{n} by \code{d} matrix of random vectors
}
\description{
Simulate multivariate Student-t \eqn{\boldsymbol{x}}
with location vector \code{mu}, scale matrix \code{sigma} and  \code{df} (integer) degrees of freedom
subject to the linear constraint \eqn{\boldsymbol{\beta}^\top\boldsymbol{x} > 0}.
Negative degrees of freedom or values larger than 1000 imply Gaussian vectors are generated instead.
}
\keyword{internal}
