% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{midas_sim}
\alias{midas_sim}
\title{Simulate simple MIDAS regression response variable}
\usage{
midas_sim(n, x, theta, rand_gen = rnorm, innov = rand_gen(n, ...), ...)
}
\arguments{
\item{n}{The sample size}

\item{x}{a \code{ts} object with MIDAS regression predictor variable}

\item{theta}{a vector with MIDAS regression coefficients}

\item{rand_gen}{the function which generates the sample of innovations, the default is \code{\link{rnorm}}}

\item{innov}{the vector with innovations, the default is NULL, i.e. innovations are generated using argument \code{rand_gen}}

\item{...}{additional arguments to \code{rand_gen}.}
}
\value{
a \code{ts} object
}
\description{
Given the predictor variable and the coefficients simulate MIDAS regression response variable.
}
\details{
MIDAS regression with one predictor variable has the following form:

\deqn{y_t=\sum_{j=0}^{h}\theta_jx_{tm-j}+u_t,}
where \eqn{m} is the frequency ratio and
\eqn{h} is the number of high frequency lags included in the regression. 

MIDAS regression involves times series with different frequencies. In R
the frequency property is set when creating time series objects
\code{\link{ts}}. Hence the frequency ratio \eqn{m} which figures in MIDAS regression is calculated from frequency property of time series objects supplied.
}
\examples{
##The parameter function
theta_h0 <- function(p, dk) {
   i <- (1:dk-1)/100
   pol <- p[3]*i + p[4]*i^2
   (p[1] + p[2]*i)*exp(pol)
}

##Generate coefficients
theta0 <- theta_h0(c(-0.1,10,-10,-10),4*12)

##Plot the coefficients
plot(theta0)

##Generate the predictor variable, leave 4 low frequency lags of data for burn-in.
xx <- ts(arima.sim(model = list(ar = 0.6), 600 * 12), frequency = 12)

##Simulate the response variable
y <- midas_sim(500, xx, theta0)

x <- window(xx, start=start(y))
midas_r(y ~ mls(y, 1, 1) + fmls(x, 4*12-1, 12, theta_h0), start = list(x = c(-0.1, 10, -10, -10)))

}
\author{
Virmantas Kvedaras, Vaidotas Zemlys
}
