% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_sgl.R
\name{predict.panel_sgl}
\alias{predict.panel_sgl}
\title{Computes prediction for the sg-LASSO panel regression model}
\usage{
\method{predict}{panel_sgl}(object, newX, newZ = NULL, regress_choice = c("re", "fe"), ...)
}
\arguments{
\item{object}{fit object from \code{panel_sgl}.}

\item{newX}{matrix of out-of-sample covariate observations.}

\item{newZ}{optional matrix of dummies for panel data model.}

\item{regress_choice}{choose between `re` and `fe`. Must be consistent with \code{object}.}

\item{...}{currently ignored optional parameters.}
}
\value{
a list of these variables:

pred - overall prediction.

predZ - dummies prediction.

predX - covariates prediction.
}
\description{
Computes prediction for the sg-LASSO panel regression model
}
\examples{
\donttest{
set.seed(1)
t <- 10; n = 5; p = 20; size.groups = 4 
index <- ceiling(1:p / size.groups)
X <- matrix(rnorm(n * t * p), ncol = p, nrow = n*t)
beta <- c(5,4,3,2,1)
y <- X[,1:5] \%*\% beta + 5*rnorm(n*t)
Z <- kronecker(diag(n), rep(1, times = t))
entity_indices <- sort(rep(1:n,times=t-1))
fit <- panel_sgl(X = X, Z = Z, y = y, index = index, 
         entity_indices = entity_indices, gamma_w = 1, 
         regress_choice = "fe", method_choice = "ic", 
         num_cores = 2, verbose = FALSE)
predict.panel_sgl(object = fit, newX = X, newZ = Z, regress_choice = "fe")$pred
}
}
\author{
Jonas Striaukas
}
