% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaze.R
\name{gaze}
\alias{gaze}
\alias{gaze.lm}
\alias{gaze.micsr}
\alias{gaze.ivreg}
\alias{gaze.rdrobust}
\alias{gaze.CJMrddensity}
\alias{gaze.htest}
\alias{gaze.anova}
\alias{gaze.LMtestlist}
\title{Short print of the summary of an object}
\usage{
gaze(x, ...)

\method{gaze}{lm}(
  x,
  ...,
  coef = NULL,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = FALSE
)

\method{gaze}{micsr}(
  x,
  ...,
  coef = NULL,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = FALSE
)

\method{gaze}{ivreg}(
  x,
  ...,
  coef,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars")
)

\method{gaze}{rdrobust}(x, ..., first_stage = FALSE)

\method{gaze}{CJMrddensity}(x, ...)

\method{gaze}{htest}(x, ..., digits = 3)

\method{gaze}{anova}(x, ..., digits = 3)

\method{gaze}{LMtestlist}(x, ..., digits = 3)
}
\arguments{
\item{x}{an object,}

\item{...}{further arguments for the different methods,}

\item{coef}{the coefficients to be printed}

\item{digits}{the number of digits for the \code{lm} and the \code{ivreg}
methods}

\item{signif.stars}{a boolean indicating whether the stars should
be printed}

\item{first_stage}{a boolean for the \code{rdrobust::rdrobust} method,
if \code{TRUE} the results of the first stage estimation are printed}
}
\value{
returns invisibly its first argument
}
\description{
\code{print} and \code{print.summary} methods often returns long input, which
is suitable for the console, but too verbal for a printed output
like a book or an article written using quarto. \code{gaze} is a generic
function which prints a short output
}
\examples{
t.test(extra ~ group, sleep) \%>\% gaze
lm(dist ~ poly(speed, 2), cars) \%>\% gaze
lm(dist ~ poly(speed, 2), cars) \%>\% gaze(coef = "poly(speed, 2)2")
}
\keyword{misc}
