% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkFunctions.R
\name{plotMMKinetics}
\alias{plotMMKinetics}
\title{plot MM kinetics of both absorption and clearance}
\usage{
plotMMKinetics(pkModel, doseRange, concentrationRange,
  absorptionYRange = NULL, clearanceYRange = NULL)
}
\arguments{
\item{pkModel}{an object of \code{\link{PkModel-class}}}

\item{doseRange}{numeric vector representing the range of doses for absorption plot}

\item{concentrationRange}{numeric vector representing the range of concentrations for the clearance plot}

\item{absorptionYRange}{numeric vector of size 2 specifying y-limits for the absorption plot, defaults to \code{NULL}}

\item{clearanceYRange}{numeric vector of size 2 specifying y-limits for the clearance plot, defaults to \code{NULL}}
}
\value{
ggplot2 object
}
\description{
plot MM kinetics of both absorption and clearance
}
\examples{
   plotMMKinetics( pkModel = getExamplePkModel() , 
      doseRange = seq( 0 , 5 , 0.1 ) , 
      concentrationRange = seq( 0 , 2.5 , 0.1  ) )
   plotMMKinetics( pkModel = getExamplePkModel() , 
       doseRange = seq( 0 , 5 , 0.1 ) , 
       concentrationRange = seq( 0 , 2.5 , 0.1  ) , 
       clearanceYRange = c( 0 , 50 ) , absorptionYRange = c( 0 , 10 )  )
}
