% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internalHelpers.R
\name{getCombinationsWithMaxNRepetitions}
\alias{getCombinationsWithMaxNRepetitions}
\title{get all combinations with a maximum number of repetitions}
\usage{
getCombinationsWithMaxNRepetitions(sourceVector, nDraws,
  maxRepetitions = 1, nCombinationsOnly = FALSE)
}
\arguments{
\item{sourceVector}{is a vector with options to draw from}

\item{nDraws}{the combination size}

\item{maxRepetitions}{the number of times an element of the \code{sampleVector} can occur in a group}

\item{nCombinationsOnly}{if TRUE it returns the number of combinations instead of the combinations itself, defaults to FALSE}
}
\value{
a matrix with as a combination per row, unless \code{nCombinationsOnly} is \code{TRUE}
}
\description{
get all combinations with a maximum number of repetitions
}
\examples{
test1    <-  getCombinationsWithMaxNRepetitions( c("a" , "b" , "c" ) ,
 nDraws = 2, maxRepetitions = 2 )
test2    <-  getCombinationsWithMaxNRepetitions( 1:5 , nDraws = 3, maxRepetitions = 3 )
test3    <-  getCombinationsWithMaxNRepetitions( 1:5 , nDraws = 3, maxRepetitions = 3 ,
 nCombinationsOnly = TRUE  )
}
