% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmpl.R
\docType{data}
\name{xmpl}
\alias{xmpl}
\alias{xmpl.bdist}
\alias{xmpl.bclst}
\alias{xmpl.panmat}
\title{Data sets for use in examples}
\usage{
data(xmpl.bdist)
data(xmpl.bclst)
data(xmpl.panmat)
}
\description{
This data set contains several files with various objects used in examples
in some of the functions in the \code{micropan} package.
}
\details{
\samp{xmpl.bdist} is a \code{tibble} with 4 columns holding all
BLAST distances between pairs of proteins in an example with 10 small genomes.

\samp{xmpl.bclst} is a clustering vector of all proteins in the
genomes from \samp{xmpl.bdist}.

\samp{xmpl.panmat} is a pan-matrix with 10 rows and 1210 columns
computed from \samp{xmpl.bclst}.
}
\examples{

# BLAST distances, only the first 20 are displayed
data(xmpl.bdist)
head(xmpl.bdist)

# Clustering vector
data(xmpl.bclst)
print(xmpl.bclst[1:30])

# Pan-matrix
data(xmpl.panmat)
head(xmpl.panmat)

}
\author{
Lars Snipen and Kristian Hovde Liland.
}
