% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rarefaction.R
\name{rarefaction}
\alias{rarefaction}
\title{Rarefaction curves for a pan-genome}
\usage{
rarefaction(pan.matrix, n.perm = 1)
}
\arguments{
\item{pan.matrix}{A pan-matrix, see \code{\link{panMatrix}} for details.}

\item{n.perm}{The number of random genome orderings to use. If \samp{n.perm=1} the fixed order of
the genomes in \samp{pan.matrix} is used.}
}
\value{
A table with the curves in the columns. The first column is the number of genomes, while 
all other columns are the cumulative number of clusters, one column for each permutation.
}
\description{
Computes rarefaction curves for a number of random permutations of genomes.
}
\details{
A rarefaction curve is simply the cumulative number of unique gene clusters we observe as
more and more genomes are being considered. The shape of this curve will depend on the order of the
genomes. This function will typically compute rarefaction curves for a number of (\samp{n.perm})
orderings. By using a large number of permutations, and then averaging over the results, the effect
of any particular ordering is smoothed.

The averaged curve illustrates how many new gene clusters we observe for each new genome. If this
levels out and becomes flat, it means we expect few, if any, new gene clusters by sequencing more
genomes. The function \code{\link{heaps}} can be used to estimate population openness based on this
principle.
}
\examples{
# Loading a pan-matrix in this package 
data(xmpl.panmat)

# Rarefaction
rar.tbl <- rarefaction(xmpl.panmat, n.perm = 1000)

\dontrun{
# Plotting
library(ggplot2)
library(tidyr)
rar.tbl \%>\% 
  gather(key = "Permutation", value = "Clusters", -Genome) \%>\% 
  ggplot(aes(x = Genome, y = Clusters, group = Permutation)) +
    geom_line()
}

}
\seealso{
\code{\link{heaps}}, \code{\link{panMatrix}}.
}
\author{
Lars Snipen and Kristian Hovde Liland.
}
