% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packages.R
\name{addPackage}
\alias{addPackage}
\title{Adds a package-file to the repository}
\usage{
addPackage(
  fn,
  type = c("source", "mac.binary", "win.binary"),
  repo_dir,
  is.new = TRUE
)
}
\arguments{
\item{fn}{Path to package}

\item{type}{Type of package, see explanation in section
"Binary packages" in \code{\link[utils:install.packages]{utils::install.packages()}}.}

\item{repo_dir}{Path to local directory, where the root of the repository is.
The (source) packages will be stored locally at
\verb{\{repo_dir\}/src/contrib/}.}

\item{is.new}{Logical, if \code{TRUE}, it causes an error if the file}
}
\value{
Invisibly returns the number of packages described in the resulting
\code{'PACKAGES'}, \code{'PACKAGES.gz'} and \code{'PACKAGES.rds'} files.
If \code{0}, no packages were found and no files were written.
}
\description{
Methods for taking a file (".tar.gz", ".zip", ".tgz") and placing it in the
repository, all locally.
}
\examples{
f <- system.file('extdata/microCRAN_0.1.0.zip', package = 'microCRAN', mustWork = TRUE)
root <- tempdir()
addPackage(f, type = 'win.binary', repo_dir = root)

}
\seealso{
\code{\link[miniCRAN:addLocalPackage]{miniCRAN::addLocalPackage()}}, \code{\link[tools:writePACKAGES]{tools::write_PACKAGES()}}
}
