% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propdiff_ac.R
\name{propdiff_ac}
\alias{propdiff_ac}
\title{Calculates the difference between proportions and standard error
according to method Agresti-Caffo}
\usage{
propdiff_ac(y, x, formula, data)
}
\arguments{
\item{y}{0-1 binary response variable.}

\item{x}{0-1 binary independent variable.}

\item{formula}{A formula object to specify the model as normally used by glm.}

\item{data}{An objects of class \code{milist}, created by
\code{df2milist}, \code{list2milist} or \code{mids2milist}.}
}
\value{
The difference between proportions, the standard error
according to Agresti-Caffo and complete data degrees of freedom
(dfcom) as n-1.
}
\description{
\code{propdiff_ac} Calculates the difference between proportions
and standard error according to method Agresti-Caffo.
}
\examples{

imp_dat <- df2milist(lbpmilr, impvar="Impnr")
ra <- with(imp_dat, expr=propdiff_ac(Chronic ~ Radiation))

# same as
ra <- with(imp_dat, expr=propdiff_ac(y=Chronic, x=Radiation))

}
\seealso{
\code{\link{with.milist}}, \code{\link{pool_propdiff_ac}}
}
\author{
Martijn Heymans, 2021
}
