% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levene_test.R
\name{levene_test}
\alias{levene_test}
\title{Calculates the Levene's test}
\usage{
levene_test(y, x, formula, data)
}
\arguments{
\item{y}{numeric (continuous) response variable.}

\item{x}{categorical group variable.}

\item{formula}{A formula object to specify the model as normally
used by glm. Use 'factor' to define the grouping x variable. Only
one variable is allowed.}

\item{data}{An objects of class \code{milist}, created by
\code{df2milist}, \code{list2milist} or \code{mids2milist}.}
}
\value{
An object from which the following objects are extracted:
\itemize{
\item  \code{fstats} F-test value, including numerator and
denominator degrees of freedom.
\item  \code{qhat} model coefficients.
\item  \code{vcov} variance-covariance matrix.
\item  \code{dfcom} degrees of freedom obtained from \code{df.residual}.
}
}
\description{
\code{levene_test} Calculates the Levene's test for homogeneity
of variance across groups, model coefficients, the
variance-covariance matrix and the degrees of freedom.
}
\details{
The Levene's test centers on group means to calculate
outcome residuals, the Brown-Forsythe test on the median.
}
\examples{

imp_dat <- df2milist(lbpmilr, impvar="Impnr")
ra <- with(imp_dat, expr=levene_test(Pain ~ factor(Carrying)))


}
\seealso{
\code{\link{with.milist}}, \code{\link{pool_levenetest}}, \code{\link{bf_test}}
}
\author{
Martijn Heymans, 2021
}
