% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polymorphism.R
\name{extract_snp}
\alias{extract_snp}
\title{Extract SNPs from abstracts in data frame}
\usage{
extract_snp(
  df,
  pattern = snp_pattern,
  col.abstract = Abstract,
  indicate = FALSE,
  discard = FALSE
)
}
\arguments{
\item{df}{Data frame containing abstracts.}

\item{pattern}{String. Regex pattern to identify SNPs.}

\item{col.abstract}{Symbol. Column containing abstracts.}

\item{indicate}{Boolean. If \code{indicate = TRUE}, add another column called
"SNP_present", verbally indicating if a SNP is present in an abstract.}

\item{discard}{Boolean. If \code{discard = TRUE}, only abstracts containing a
SNP are kept.}
}
\value{
Data frame. If \code{discard = FALSE}, return the data frame with
an additional column for SNPs.
If \code{discard = TRUE}, return only abstracts containing SNPs.
}
\description{
Extract SNPs from abstracts in a data frame.
}
\details{
Extract SNPs from abstracts in a data frame. SNPs are added to the data
frame in a separate column. Furthermore, an optional column can indicate if
SNPs are generally present in an abstract.
}
\seealso{
\code{\link[=count_snp]{count_snp()}},
\code{\link[=get_snp]{get_snp()}},
\code{\link[=subset_snp]{subset_snp()}}

Other extract functions: 
\code{\link{extract_mir_df}()},
\code{\link{extract_mir_string}()}
}
\concept{extract functions}
