% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/milags_functions.R
\name{get_init_pars_logistic}
\alias{get_init_pars_logistic}
\title{get_init_pars_logistic}
\usage{
get_init_pars_logistic(
  data_this_curve,
  this_n0,
  init_K,
  init_lag,
  init_gr_rate,
  min_b = 0.2,
  min_a = 0.8
)
}
\arguments{
\item{data_this_curve}{data from one specific growth curve with these two columns: time and biomass}

\item{this_n0}{the initial biomass}

\item{init_K}{initial value for the saturation parameter K}

\item{init_lag}{initial value for the lag parameter}

\item{init_gr_rate}{initial value for the growth rate}

\item{min_b}{defaults to 0.2; mina and minb define where to look for exponential phase: it will be where the biomass is between min + (max-min)*(min_a TO min_b)}

\item{min_a}{defaults to 0.8}
}
\value{
list of parameters: init_K, init_lag, init_gr_rate,
}
\description{
Finds reasonable approximation for logistic growth curve parameters (K, lag. growth rate) based on the growth curve and some initial values
These approximations will be used as the initial values for the proper optimization algorithm run later.
}
