% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.contrast.R
\name{make.contrast}
\alias{make.contrast}
\title{Builds the contrast matrix}
\usage{
make.contrast(design, condition, contrast = 1)
}
\arguments{
\item{design}{The data.frame which correspond to the pData function of 
MSnbase}

\item{condition}{xxxxx}

\item{contrast}{An integer that Indicates if the test consists of the 
comparison of each biological condition versus each of the other ones 
(Contrast=1; for example H0:"C1=C2" vs H1:"C1!=C2", etc.) 
or each condition versus all others (Contrast=2; e.g.  H0:"C1=(C2+C3)/2" vs
 H1:"C1!=(C2+C3)/2", etc. if there are three conditions).}
}
\value{
A constrat matrix
}
\description{
This function builds the contrast matrix
}
\examples{
\dontrun{
utils::data(Exp1_R25_pept, package='DAPARdata')
design <- make.design(Biobase::pData(Exp1_R25_pept))
conds <- Biobase::pData(Exp1_R25_pept)$Condition
make.contrast(design, conds)
}

}
\author{
Thomas Burger, Quentin Giai-Gianetto, Samuel Wieczorek originally in 
the DAPAR package. Included in this package since DAPAR is to be removed from 
Bioconductor >= 3.15.
}
