% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidths_MGWRSAR.R
\name{bandwidths_mgwrsar}
\alias{bandwidths_mgwrsar}
\title{bandwidths_mgwrsar}
\usage{
bandwidths_mgwrsar(formula, data,coords,
fixed_vars='Intercept',Models='GWR',candidates_Kernels='bisq',
control=list(),control_search=list())
}
\arguments{
\item{formula}{a formula.}

\item{data}{a dataframe or a spatial dataframe (sp package).}

\item{coords}{a dataframe or a matrix with coordinates, not required if data is a spatial dataframe, default NULL.}

\item{fixed_vars}{a vector with the names of spatially constant coefficient. For mixed model, if NULL, the default
#' is set to 'Intercept'.}

\item{Models}{character containing the type of model: Possible values are "OLS",
"SAR", "GWR" (default), "MGWR" , "MGWRSAR_0_0_kv","MGWRSAR_1_0_kv",
"MGWRSAR_0_kc_kv", "MGWRSAR_1_kc_kv", "MGWRSAR_1_kc_0".}

\item{candidates_Kernels}{a vector with the names of kernel type.}

\item{control}{list of extra control arguments for MGWRSAR wrapper - see MGWRSAR help.}

\item{control_search}{list of extra control arguments for bandwidth/kernel search - see details below.}
}
\value{
bandwiths_MGWRSAR returns a list with:
\describe{
\item{config_model}{a vector with information about model, optimal kernel and
bandwidth for local regression, and optimal kernel and bandwith for spatial weight matrix W.}
\item{SSR}{The sum of square residuals.}
\item{CV}{The CV criteria.}
\item{model}{objects of class mgwrsar estimated using config_model}
}
}
\description{
Select optimal kernel and bandwidth from a list of models, kernels and bandwidth candidates.
a bandwidth value for each of the chosen models and kernel types using a leave-one-out cross validation criteria.
A cross validated criteria is also used for selecting the best kernel type for a given model.
}
\details{
\describe{
\item{search_W}{if TRUE select an optimal spatial weight matrix using a moment estimator, default FALSE.}
\item{kernels_w}{if search_W is TRUE, kernels_w is a vector of candidated kernels types, default NULL.}
\item{lower_c}{lower bound for bandwidth search (default, the approximate first decile of distances).}
\item{upper_c}{upper bound for bandwidth search  (default, the approximate last decile of distances).}
\item{lower_d}{lower bound for discrete kernels, default 2*k+1.}
\item{lower_dW}{ower bound for discrete kernels for finding optimal spatial weight matrix, default 2.}
\item{lower_cW}{lower bound for  bandwidth search for finding optimal spatial
weight matrix  (default approximate 0.005 quantile of distances).}
}
}
\examples{
\donttest{
library(mgwrsar)
## loading data example
data(mydata)
coords=as.matrix(mydata[,c("x","y")])
mytab<-bandwidths_mgwrsar(formula = 'Y_gwr~X1+X2+X3', data = mydata,coords=coords,
fixed_vars=c('Intercept','X1'),Models=c('GWR','MGWR'),candidates_Kernels=c('bisq','gauss'),
control=list(NN=300,adaptive=TRUE),control_search=list())

names(mytab)
names(mytab[['GWR_bisq_adaptive']])

mytab[['GWR_bisq_adaptive']]$config_model
mytab[['GWR_bisq_adaptive']]$CV
summary(mytab[['GWR_bisq_adaptive']]$model$Betav)

mybestmodel=mytab[['GWR_gauss_adaptive']]$model
plot_mgwrsar(mybestmodel,type='B_coef',var='X2')
}
}
\references{
Geniaux, G. and Martinetti, D. (2017). A new method for dealing simultaneously with spatial autocorrelation and spatial heterogeneity in regression models. Regional Science and Urban Economics. (https://doi.org/10.1016/j.regsciurbeco.2017.04.001)


McMillen, D. and Soppelsa, M. E. (2015). A conditionally parametric probit model of
microdata land use in chicago. Journal of Regional Science, 55(3):391-415.

Loader, C. (1999). Local regression and likelihood, volume 47. Springer New York.

Franke, R. and Nielson, G. (1980). Smooth interpolation of large sets of scattered data.
International journal for numerical methods in engineering, 15(11):1691-1704.
}
\seealso{
MGWRSAR, summary_mgwrsar, plot_mgwrsar, predict_mgwrsar
}
