% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_report.R
\name{read_mrk_list_rpt}
\alias{read_mrk_list_rpt}
\title{Read a marker list report}
\usage{
read_mrk_list_rpt(file, n_max = Inf)
}
\arguments{
\item{file}{Path to a report file.}
}
\value{
A \link[tibble:tibble-package]{tibble} with the following variables (or
a subset of):
\describe{
\item{marker_id}{Character. The unique MGI identifier for the marker.}
\item{marker_symbol}{Character. The MGI symbol representing the marker.}
\item{marker_name}{Character. The full name of the marker.}
\item{marker_type}{Factor. The type of the marker (e.g., Gene, BAC/YAC end,
DNA segment).}
\item{status}{Factor. The status of the marker (e.g., \code{"O"} for official or
\code{"W"} for withdrawn).}
\item{cM_pos}{Double. The position of the marker in centiMorgans (cM) on
the chromosome.}
\item{chr}{Factor. The chromosome on which the marker is located.}
\item{start}{Integer. The start position of the marker on the chromosome.}
\item{end}{Integer. The end position of the marker on the chromosome.}
\item{strand}{Factor. The DNA strand on which the marker is located (e.g.,
plus (\code{"+"}) or minus (\code{"-"})).}
\item{feature_type}{Character. The feature type of the marker (e.g., gene,
lncRNA gene, DNA segment). In most cases a sequence ontology term.}
\item{synonyms}{List-column. A list of synonyms for the marker.}
}
}
\description{
\code{\link[=read_mrk_list_rpt]{read_mrk_list_rpt()}} imports either a \code{MRK_List1.rpt} or a \code{MRK_List2.rpt}
report file. See \href{https://www.informatics.jax.org/downloads/reports/index.html}{MGI Data and Statistical Reports} for
more details.
}
\keyword{internal}
