% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_nested1D.R
\name{plot.nested1D}
\alias{plot.nested1D}
\title{Plotting one dimensional nested effects}
\usage{
\method{plot}{nested1D}(
  x,
  inner = FALSE,
  n = 100,
  xlim = NULL,
  ylim = NULL,
  maxpo = 10000,
  trans = identity,
  ...
)
}
\arguments{
\item{x}{a smooth effect object.}

\item{inner}{if TRUE we are doing to plot the inner transformation, rather that then
outer smooth effect.}

\item{n}{number of grid points used to compute main effect and c.i. lines.
For a nice smooth plot this needs to be several times the estimated degrees of
freedom for the smooth.}

\item{xlim}{if supplied then this pair of numbers are used as the x limits for the plot.}

\item{ylim}{if supplied then this pair of numbers are used as the y limits for the plot.}

\item{maxpo}{maximum number of residuals points that will be used by layers such as
\code{resRug()} and \code{resPoints()}. If number of datapoints > \code{maxpo},
then a subsample of \code{maxpo} points will be taken.}

\item{trans}{monotonic function to apply to the smooth and residuals, before plotting.
Monotonicity is not checked.}

\item{...}{currently unused.}
}
\value{
An object of class \code{c("plotSmooth", "gg")}.
}
\description{
This method should be used to plot smooth effects
of class \code{"si.smooth.1D"}.
}
