% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRGL_mgcv_smooth_2D.R
\name{plotRGL.mgcv.smooth.2D}
\alias{plotRGL.mgcv.smooth.2D}
\title{Visualizing 2D smooth effects in 3D}
\usage{
\method{plotRGL}{mgcv.smooth.2D}(x, se = TRUE, n = 40,
  residuals = FALSE, type = "auto", maxpo = 1000, too.far = 0,
  xlab = NULL, ylab = NULL, main = NULL, xlim = NULL,
  ylim = NULL, se.mult = 1, trans = identity, seWithMean = FALSE,
  unconditional = FALSE, ...)
}
\arguments{
\item{x}{a smooth effect object, extracted using \link[mgcViz:sm]{mgcViz::sm}.}

\item{se}{when TRUE (default) upper and lower surfaces are added to the plot at \code{se.mult}
(see below) standard deviations for the fitted surface.}

\item{n}{sqrt of the number of grid points used to compute the effect plot.}

\item{residuals}{if TRUE, then the partial residuals will be added.}

\item{type}{the type of residuals that should be plotted. See \link{residuals.gamViz}.}

\item{maxpo}{maximum number of residuals points that will be plotted.
If number of datapoints > \code{maxpo}, then a subsample of \code{maxpo} points will be taken.}

\item{too.far}{if greater than 0 then this is used to determine when a location is too far
from data to be plotted. This is useful since smooths tend to go wild
away from data. The data are scaled into the unit square before deciding
what to exclude, and too.far is a distance within the unit square.
Setting to zero can make plotting faster for large datasets, but care
then needed with interpretation of plots.}

\item{xlab}{if supplied then this will be used as the x label of the plot.}

\item{ylab}{if supplied then this will be used as the y label of the plot.}

\item{main}{used as title for the plot if supplied.}

\item{xlim}{if supplied then this pair of numbers are used as the x limits for the plot.}

\item{ylim}{if supplied then this pair of numbers are used as the y limits for the plot.}

\item{se.mult}{a positive number which will be the multiplier of the standard errors
when calculating standard error surfaces.}

\item{trans}{monotonic function to apply to the smooth and residuals, before plotting.
Monotonicity is not checked.}

\item{seWithMean}{if TRUE the component smooths are shown with confidence intervals that
include the uncertainty about the overall mean. If FALSE then the uncertainty
relates purely to the centred smooth itself. Marra and Wood (2012) suggests
that TRUE results in better coverage performance, and this is also suggested
by simulation.}

\item{unconditional}{if \code{TRUE} then the smoothing parameter uncertainty corrected covariance
matrix is used to compute uncertainty bands, if available.
Otherwise the bands treat the smoothing parameters as fixed.}

\item{...}{currently unused.}
}
\value{
Returns \code{NULL} invisibly.
}
\description{
This method plots an interactive 3D representation of a 2D smooth effect, using
the \link{rgl} package.
}
\examples{
# Example 1: taken from ?mgcv::te, shows how tensor pruduct deals nicely with 
# badly scaled covariates (range of x 5\% of range of z )
library(mgcViz)

# Simulate some data
test1 <- function(x,z,sx=0.3,sz=0.4) { 
  x <- x*20
  (pi**sx*sz)*(1.2*exp(-(x-0.2)^2/sx^2-(z-0.3)^2/sz^2)+
                 0.8*exp(-(x-0.7)^2/sx^2-(z-0.8)^2/sz^2))
}
n <- 500
old.par <- par(mfrow=c(2,2))
x <- runif(n)/20;z <- runif(n);
xs <- seq(0,1,length=30)/20;zs <- seq(0,1,length=30)
pr <- data.frame(x=rep(xs,30),z=rep(zs,rep(30,30)))
truth <- matrix(test1(pr$x,pr$z),30,30)
f <- test1(x,z)
y <- f + rnorm(n)*0.2

# Fit with t.p.r.s. basis and plot
b1 <- gam(y~s(x,z))
plotRGL(sm(getViz(b1), 1))

rgl.close() # Close

# Fit with tensor products basis and plot (with residuals)
b2 <- gam(y~te(x,z))
plotRGL(sm(getViz(b2), 1), residuals = TRUE)

# We can still work on the plot, for instance change the aspect ratio
library(rgl)
aspect3d(1, 2, 1)

rgl.close() # Close
}
\references{
Marra, G and S.N. Wood (2012) Coverage Properties of Confidence Intervals for
Generalized Additive Model Components. Scandinavian Journal of Statistics.
}
