% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{mgc.sims.quad}
\alias{mgc.sims.quad}
\title{Quadratic Simulation}
\usage{
mgc.sims.quad(n, d, eps = 0.5, ind = FALSE, a = -1, b = 1)
}
\arguments{
\item{n}{the number of samples for the simulation.}

\item{d}{the number of dimensions for the simulation setting.}

\item{eps}{the noise level for the simulation. Defaults to \code{0.5}.}

\item{ind}{whether to sample x and y independently. Defaults to \code{FALSE}.}

\item{a}{the lower limit for the data matrix. Defaults to \code{-1}.}

\item{b}{the upper limit for the data matrix. Defaults to \code{1}.}
}
\value{
a list containing the following:
\item{\code{X}}{\code{[n, d]} the data matrix with \code{n} samples in \code{d} dimensions.}
\item{\code{Y}}{\code{[n]} the response array.}
}
\description{
A function for Generating a quadratic simulation.
}
\section{Details}{

Given: \eqn{w_i = \frac{1}{i}}{w[i] = 1/i} is a weight-vector that scales with the dimensionality.
Simulates \code{n} points from \eqn{Quadratic(X, Y) \in \mathbf{R}^d \times \mathbf{R}}{Quadratic(X, Y)} where:
\deqn{X \sim {U}(a, b)^d}{X ~ U(a, b)^d},
\deqn{Y = (w^TX)^2 + \kappa\epsilon N(0, 1)}{Y = (w^TX)^2 + K*eps*N(0, 1)}
and \eqn{\kappa = 1\textrm{ if }d = 1, \textrm{ and 0 otherwise}}{K = 1 if d=1, and 0 otherwise} controls the noise for higher dimensions.

For more details see the help vignette:
\code{vignette("sims", package = "mgc")}
}

\examples{
library(mgc)
result  <- mgc.sims.quad(n=100, d=10)  # simulate 100 samples in 10 dimensions
X <- result$X; Y <- result$Y
}
\author{
Eric Bridgeford
}
