% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{find_scale_factor}
\alias{find_scale_factor}
\title{Function that calculates an integer used to scale predictor}
\usage{
find_scale_factor(x)
}
\arguments{
\item{x}{a numeric vector already shifted to positive values (see
\code{\link[=find_shift_factor]{find_shift_factor()}}). This function requires at least 2 distinct values to
work.

#' @examples
x = 1:1000
find_scale_factor(x)}
}
\value{
An integer that can be used to scale \code{x} to a reasonable range. For binary
variables 1 is returned.
}
\description{
Function that calculates an integer used to scale predictor
}
\details{
For details on why scaling is useful see the corresponding section in the
documentation of \code{\link[=mfp2]{mfp2()}}.

The determination of the scaling factor is independent (i.e. not affected
by) shifts in the input data, as it only depends on the range of the
input data.

Note that the estimation of powers is unaffected by scaling, the same powers
are found for scaled input data. In extreme cases scaling is necessary to
preserve accuracy, see Royston and Sauerbrei (2008).
This formula uses the scaling formula from Section 4.11.1 of
Royston and Sauerbrei (2008). Further information can also be found in the
Stata manual for mfp at https://www.stata.com/manuals/rfp.pdf.
}
\references{
Royston, P., and Sauerbrei, W., 2008. \emph{Multivariable Model - Building:
A Pragmatic Approach to Regression Anaylsis based on Fractional Polynomials
for Modelling Continuous Variables. John Wiley & Sons.}
}
