% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{calculate_lr_test}
\alias{calculate_lr_test}
\title{Function to calculate p-values for likelihood-ratio test}
\usage{
calculate_lr_test(logl, dfs)
}
\arguments{
\item{logl}{a numeric vector of length 2 with log-likelihoods. Typically
ordered in increasing order (i.e. null model first, then full model) and
used to test the ratio \code{logl[1] / logl[2]}.}

\item{dfs}{a numeric vector with degrees of freedom.}
}
\value{
A list with two entries for the likelihood ratio test for the ratio
\code{logl[1] / logl[2]}.
\itemize{
\item \code{statistic}: test statistic.
\item \code{pvalue}: p-value
}
}
\description{
Function to calculate p-values for likelihood-ratio test
}
\details{
Uses Wilk's theorem that -2log(LR) (LR = likelihood ratio) asymptotically
approaches a Chi-square distribution under the null hypothesis that both
likelihoods are equal.

Model likelihoods can then be compared by computing
D = -2 log(likelihood reduced model / likelihood full model), and then
use a Chi-square distribution with df_full - df_reduced degrees
of freedom to derive a p-value.

This is basically the same way as \code{\link[stats:anova]{stats::anova()}} implements the
likelihood ratio test.
}
