% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penultimate.R
\name{egp-function}
\alias{egp-function}
\alias{egp.ll}
\alias{egp.retlev}
\title{Extended generalised Pareto families of Papastathopoulos and Tawn (functions)}
\usage{
egp.ll(xdat, thresh, par, model = c("egp1", "egp2", "egp3"))

egp.retlev(xdat, thresh, par, model = c("egp1", "egp2", "egp3"), p,
  plot = TRUE)
}
\arguments{
\item{xdat}{vector of observations, greater than the threshold}

\item{thresh}{threshold value}

\item{par}{parameter vector (\eqn{\kappa}, \eqn{\sigma},\eqn{\xi}).}

\item{model}{a string indicating which extended family to fit}

\item{p}{extreme event probability; \code{p} must be greater than the rate of exceedance for the calculation to make sense. See \bold{Details}.}

\item{plot}{boolean indicating whether or not to plot the return levels}
}
\description{
This function provides the log-likelihood and quantiles for the three different families presented
in Papastathopoulos and Tawn (2013). The latter include an additional parameter, \eqn{\kappa}.
All three families share the same tail index than the GP model, while allowing for lower thresholds.
}
\keyword{internal}

