% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Northrop_Coleman_Extremes_2014.R
\name{gp.fit}
\alias{gp.fit}
\title{Peaks-Over-Threshold Modelling using the Generalized Pareto Distribution}
\usage{
gp.fit(xdat, threshold, method = c("Grimshaw", "nlm", "optim", "ismev", "zs",
  "zhang"), show = TRUE, MCMC = NULL)
}
\arguments{
\item{xdat}{a numeric vector of data to be fitted.}

\item{threshold}{the chosen threshold.}

\item{method}{the method to be used. See \bold{Details}. Can be abbreviated.}

\item{show}{logical; if \code{TRUE} (the default), print details of the fit.}

\item{MCMC}{\code{NULL} for frequentist estimates, otherwise a boolean or a list with parameters passed. If \code{TRUE}, runs a Metropolis-Hastings sampler to get posterior mean estimates. Can be used to pass arguments \code{niter}, \code{burnin} and \code{thin} to the sampler as a list.}
}
\value{
If \code{method} is neither \code{"zs"} nor \code{"zhang"}, a list containing the following components:
\itemize{
\item \code{estimate} a vector containing all parameters (optimized and fixed).
\item \code{std.err} a vector containing the standard errors.
\item \code{var.cov} the variance covariance matrix, obtained as the numerical inverse of the observed information matrix.
\item \code{threshold} the threshold.
\item \code{method} the method used to fit the parameter. See details.
\item \code{deviance} the deviance at the maximum likelihood estimates.
\item \code{nat} number of points lying above the threshold.
\item \code{pat} proportion of points lying above the threshold.
\item \code{convergence} components taken from the list returned by \code{\link[stats]{optim}}.
Values other than \code{0} indicate that the algorithm likely did not converge (in particular 1 and 50).
\item \code{counts} components taken from the list returned by \code{\link[stats]{optim}}.
}
Otherwise, a list containing
\itemize{
\item \code{threshold} the threshold.
\item \code{method} the method used to fit the parameter. See \bold{Details}.
\item \code{nat} number of points lying above the threshold.
\item \code{pat} proportion of points lying above the threshold.
\item \code{approx.mean} a vector containing containing the approximate posterior mean estimates.
}
and in addition if MCMC is neither \code{FALSE}, nor \code{NULL}
\itemize{
\item \code{post.mean} a vector containing the posterior mean estimates.
\item \code{post.se} a vector containing the posterior standard error estimates.
\item \code{accept.rate} proportion of points lying above the threshold.
\item \code{niter} length of resulting Markov Chain
\item \code{burnin} amount of discarded iterations at start, capped at 10000.
\item \code{thin} thinning integer parameter describing
}
}
\description{
Numerical optimization of the Generalized Pareto distribution over a
high threshold.
}
\details{
The default method is \code{"Grimshaw"}, consisting in maximization of the profile likelihood for the scale.
Other options for maximization of the profile likelihood are \code{nlm} and \code{optim}, which use respectively \code{\link[stats]{nlm}} and \code{\link[stats]{optim}}. Method \code{"ismev"} is the two-dimensional optimization routine \code{\link[ismev]{gpd.fit}} from the \code{\link[ismev]{ismev}} library, with in addition the algebraic gradient.
The approximate Bayesian methods (\code{"zs"} and \code{"zhang"}) are extracted respectively from Zhang and Stephens (2009) and Zhang (2010) and consists of a approximate posterior mean calculated via importance
sampling assuming a GPD prior is placed on the parameter of the profile likelihood.
}
\note{
Some of the internal functions (which are hidden from the user) allow for modelling of the parameters using covariates. This is not currently implemented within \code{gp.fit}, but users can call internal functions should they wish to use these features. \bold{Warning}
}
\examples{
library(ismev)
data(rain)
threshold <- quantile(rain,0.9)
gp.fit(rain, threshold, method="Grimshaw")
gp.fit(rain, threshold, method="zs")
}
\author{
Paul J. Northrop and Claire L. Coleman for the frequentist functions.
Zhang and Stephens (2009) and Zhang (2010) for the \code{zs} and \code{zhang} approximate methods and L. Belzile for the wrapper and MCMC samplers.
}
\references{
Davison, A.C. (1984). Modelling excesses over high thresholds, with an application, in
\emph{Statistical extremes and applications}, J. Tiago de Oliveira (editor), D. Reidel Publishing Co., 461--482.

Grimshaw, S.D. (1993). Computing Maximum Likelihood Estimates for the Generalized
 Pareto Distribution, \emph{Technometrics}, \bold{35}(2), 185--191.

Northrop, P.J. and C. L. Coleman (2014). Improved threshold diagnostic plots for extreme value
analyses, \emph{Extremes}, \bold{17}(2), 289--303.

Zhang, J. (2010). Improving on estimation for the generalized Pareto distribution, \emph{Technometrics} \bold{52}(3), 335--339.

Zhang, J.  and M.A. Stephens (2009). A new and efficient estimation method for the generalized Pareto distribution.
\emph{Technometrics} \bold{51}(3), 316--325.
}
\seealso{
\code{\link[evd]{fpot}} and \code{\link[ismev]{gpd.fit}}
}

