% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidents-elevator.R
\name{elevator_incidents}
\alias{elevator_incidents}
\title{Elevator/Escalator Outages}
\format{
A data frame with 1 row per incident and 9 variables:
\describe{
\item{UnitName}{Unique identifier for unit, by type (a single elevator and
escalator may have the same \code{UnitName}, but no two elevators or two
escalators will have the same \code{UnitName}).}
\item{UnitType}{Type of unit. Will be \code{ELEVATOR} or \code{ESCALATOR}.}
\item{StationCode}{Unit's station code. Use this value in other
rail-related APIs to retrieve data about a station.}
\item{StationName}{Full station name, may include entrance information
(e.g.: Metro Center, G and 11th St Entrance).}
\item{LocationDescription}{Free-text description of the unit location
within a station (e.g.: Escalator between mezzanine and platform).}
\item{SymptomDescription}{Description for why the unit is out of service or
otherwise in reduced operation.}
\item{DateOutOfServ}{Date and time (UTC) unit was reported out of service.}
\item{DateUpdated}{Date and time (UTC) outage details was last updated.}
\item{EstimatedReturnToService}{Estimated date and time (UTC) by when unit
is expected to return to normal service. May be NULL.}
}
}
\usage{
elevator_incidents(StationCode = NULL, api_key = wmata_key())
}
\arguments{
\item{StationCode}{Station code. Use \code{\link[=rail_stations]{rail_stations()}} to return a list of
all station codes. Use \code{NULL} (default) to list all incidents.}

\item{api_key}{Subscription key which provides access to this API. Defaults
\code{Sys.getenv("WMATA_KEY")} via \code{\link[=wmata_key]{wmata_key()}}.}
}
\value{
Data frame of \emph{reported} elevator and escalator outages.
}
\description{
Elevator/Escalator Outages
}
\details{
Note that for stations with multiple platforms and therefore \code{StationCodes}
(e.g.: Metro Center, L'Enfant Plaza, etc.), a distinct call is required for
each \code{StationCode}.
}
\examples{
\dontrun{
elevator_incidents()
}
}
\seealso{
\url{https://developer.wmata.com/docs/services/54763641281d83086473f232/operations/54763641281d830c946a3d76}

Other Incident APIs: 
\code{\link{bus_incidents}()},
\code{\link{rail_incidents}()}
}
\concept{Incident APIs}
