% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidents-rail.R
\name{rail_incidents}
\alias{rail_incidents}
\title{Rail Incidents}
\format{
A data frame with 1 row incident and 5 variables:
\describe{
\item{IncidentID}{Unique identifier for an incident.}
\item{Description}{Free-text description of the incident.}
\item{IncidentType}{Free-text description of the incident type. Usually
Delay or Alert but is subject to change at any time.}
\item{LinesAffected}{Character vector of line codes (e.g.: RD; or BL; OR;
or BL; OR; RD;).}
\item{DateUpdated}{Date and time (UTC) of last update.}
}
}
\usage{
rail_incidents(api_key = wmata_key())
}
\arguments{
\item{api_key}{Subscription key which provides access to this API. Defaults
\code{Sys.getenv("WMATA_KEY")} via \code{\link[=wmata_key]{wmata_key()}}.}
}
\value{
Data frame of all rail incidents.
}
\description{
Reported rail incidents (significant disruptions and delays to normal
service). The data is identical to WMATA's Metrorail Service Status feed.
}
\examples{
\dontrun{
rail_incidents()
}
}
\seealso{
\url{https://developer.wmata.com/docs/services/54763641281d83086473f232/operations/54763641281d830c946a3d77}

Other Incident APIs: 
\code{\link{bus_incidents}()},
\code{\link{elevator_incidents}()}
}
\concept{Incident APIs}
