% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSS.R
\name{RSS}
\alias{RSS}
\title{Residual Sum of Squares (RSS)}
\usage{
RSS(data = NULL, obs, pred, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric}.
}
\description{
It estimates the RSS for a continuous predicted-observed dataset.
}
\details{
The RSS is the sum of the squared differences between predictions and observations.
It represents the base of many error metrics using squared scale such as the Mean Squared Error (MSE).
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- X + rnorm(n=100, mean = 0, sd = 3)
RSS(obs = X, pred = Y)
}
}
