% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runNulls.R
\name{runNulls}
\alias{runNulls}
\title{Randomize input CDM according to defined null models}
\usage{
runNulls(nulls.input, nulls)
}
\arguments{
\item{nulls.input}{A prepared nulls.input object, as generated by prepNulls.}

\item{nulls}{Optional list of named null model functions to use. If invoked, this 
option will likely be used to run a subset of the defined null models.}
}
\value{
A list of matrices. Each matrix is a product of a randomization of the input
CDM and one of the nulls from defineNulls.
}
\description{
Given a prepared nulls.input object, will randomize a community data matrix according
to all nulls defined in defineNulls, and return a list of randomized CDMs.
}
\details{
Currently we are running 9 null models.
This function first confirms that the input is of class nulls.input and, if so, then
confirms that the nulls to be calculated are in a named list (via checkNulls),
then lapplies all null model functions to the input CDM.
}
\examples{
#simulate tree with birth-death process
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

sim.abundances <- round(rlnorm(5000, meanlog=2, sdlog=1)) + 1

cdm <- simulateComm(tree, richness.vector=10:25, abundances=sim.abundances)

prepped <- prepNulls(tree, cdm)

results <- runNulls(prepped)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2015. Phylogenetic community
structure metrics and null models: a review with new methods and software.
bioRxiv 025726.
}

