% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funnelinf.R
\name{funnelinf}
\alias{funnelinf}
\title{Visual funnel plot inference for meta-analysis}
\usage{
funnelinf(x, group = NULL, group_permut = FALSE, n = 20, y_axis = "se",
  null_model = "FEM", contours = TRUE, sig_contours = TRUE,
  trim_and_fill = FALSE, trim_and_fill_side = "left", egger = FALSE,
  show_solution = FALSE)
}
\arguments{
\item{x}{data.frame or matrix with the effect sizes of all studies (e.g.,
correlations, log odds ratios, or Cohen \emph{d}) in the first column and their
respective standard errors in the second column.}

\item{group}{a factor indicating the subgroup of each study.}

\item{group_permut}{logical scalar indicating if subgroup membership should be permutated
in the null plots. Ignored if no group is supplied.}

\item{n}{integer specifying the absolute number of plots (null plots plus plot of real data)}

\item{y_axis}{Which y axis should be used in the funnel plot? Available options are se (default) for
standard error and precision for the reciprocal of the standard error.}

\item{null_model}{Which meta-analytic model should be used to simulate the effect sizes for the null plots?
Available options are FEM for the fixed effect model and REM for the random-effects model (using the
DerSimonian-Laird method to estimate the between-study variance \eqn{\tau^2}{tau squared})}

\item{contours}{logical scalar indicating if classic funnel plot contours should be displayed (i.e., summary effect +/-
rnorm(0.975) * SE).}

\item{sig_contours}{logical scalar. Should significance contours should be drawn? Significance contours show which combination of
effect size and standard error lead to p-values smaller than 0.05 or 0.01 (using a Wald test).}

\item{trim_and_fill}{logical scalar. Should studies imputed by the trim and fill method be displayed?}

\item{trim_and_fill_side}{On which side should studies be imputed by the trim and fill method? Available options are
right or left.}

\item{egger}{logical scalar. Should Egger's regression line be drawn?}

\item{show_solution}{logical scalar. Should the plot with the real data be highlighted? Default is FALSE.}
}
\value{
A lineup of n (20 by default) funnel plots; one showing the real data and n-1 showing
 simulated data under the null hypothesis
}
\description{
Creates a lineup of funnel plots to conduct visual funnel plot inference. The funnel plot showing the real, supplied data is
presented alongside null plots showing simulated data under the null hypothesis.
}
\details{
Funnel plots are widely used in meta-analysis to detect small study effects and in particular publication bias.
However, interpretations of funnel plots often lead to false conclusions (e.g., Terrin, Schmid, and Lau, 2005). Visual inference
(Buja et al. 2009; Majumder, Hofmann, and Cook 2013) can help to improve the validity of such funnel plot based conclusions.
If the alternative hypothesis is true (e.g., small study effects led to an asymmetric funnel plot), the funnel plot showing the real data
should be identifiable when presented alongside funnel plots of simulated data under the null hypothesis. Only if this is possible,
conclusion based on the funnel plot might be warranted.
}
\examples{
\dontrun{
# Plotting a funnel plot lineup with the mozart data to conduct visual funnel plot inference
# considering subgroups (for details, see help(mozart)):
funnelinf(x = mozart[, c("d", "se")],
group = mozart[, "rr_lab"],
group_permut = TRUE, null_model = "REM")
# Plotting a funnel plot lineup with the brainvolume data to conduct visual funnel plot inference
# considering heterogeneity (for details, see help(brainvol)):
funnelinf(x = brainvol[, c("z", "z_se")],
null_model = "FEM")
}
}
\references{
Buja, A., Cook, D., Hofmann, H., Lawrence, M., Lee, E. K., Swayne, D. F., & Wickham, H. (2009).
 Statistical inference for exploratory data analysis and model diagnostics.
 \emph{Philosophical Transactions of the Royal Society of London A: Mathematical, Physical and Engineering Sciences},
 \emph{367}, 4361-4383.

Majumder, M., Hofmann, H., & Cook, D. (2013). Validation of visual statistical inference, applied to linear models.
 \emph{Journal of the American Statistical Association}, \emph{108}, 942-956.

Terrin, N., Schmid, C. H., & Lau, J. (2005). In an empirical evaluation of the funnel plot, researchers could not
 visually identify publication bias. \emph{Journal of clinical epidemiology}, \emph{58}, 894-901.
}
\author{
Michael Kossmeier* <michael.kossmeier@univie.ac.at>

Ulrich S. Tran* <ulrich.tran@univie.ac.at>

Martin Voracek* <martin.voracek@univie.ac.at>

*Department of Basic Psychological Research and Research Methods, School of Psychology, University of Vienna
}
