% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaumbrella.R
\docType{package}
\name{metaumbrella-package}
\alias{metaumbrella-package}
\title{metaumbrella: An Umbrella Review Package for R}
\description{
The \pkg{metaumbrella} package offers several facilities to assist in data analysis when performing an umbrella review.
This package is built around three core functions which aim to facilitate (i) the completion of the statistical analyses required for an umbrella review (via the \code{\link{umbrella}()} function), (ii) the stratification of the evidence (via the \code{\link{add.evidence}()} function) and (iii) the graphical presentation of the results (via the \code{\link{forest}()} function).
First, the \code{\link{umbrella}()} function automatically performs meta-analyses and additional calculations needed for an umbrella review. It outputs an object of the class umbrella.
The advantage of this function over standard R packages only designed for fitting a single meta-analysis lies, for example, in the possibility of automatically fitting several meta-analyses when input information differs, automatically extracting the necessary information to stratify the evidence, and automatically performing the additional tests needed (a test for excess significance bias, a test for publication bias and a jackknife leave-one-out analysis).
Second, the \code{\link{add.evidence}()} function stratifies the evidence generated by the \code{\link{umbrella}()} function according to a set of pre-specified criteria (those proposed by Prof. Ioannidis or an algorithmic version of GRADE classification), or according to a personalized classification that the users may specify manually. This feature allows users to rely on already developed criteria or to develop new ones that match the specific needs of their umbrella review.
Third, the \code{\link{forest}()} function creates graphical representations of the results of an umbrella review, including a forest plot along with information on the stratification of evidence.
To achieve automation in the calculations performed by the \code{\link{umbrella}()} function, users must pass a dataset that follows fixed rules (which we refer to as a well-formatted dataset).
We present here the rules that must be respected when creating a well-formatted dataset.
}
\section{Well-formatted dataset}{
Overall, the datasets passed to the functions of the \pkg{metaumbrella} package should contain information on each individual study included in the different meta-analyses so that the meta-analyses may be replicated.
Seven types of effect sizes are accepted (standardized mean difference (i.e., Cohen's d), mean difference, Hedges' g, odds ratio or its logarithm, risk ratio or its logarithm, hazard ratio or its logarithm and incidence rate ratio or its logarithm).

Some information is mandatory, some information varies depending on the effect size measure and some information is optional.
Note that the package includes examples of well-formatted datasets for each measure (\code{\link{df.SMD}}, \code{\link{df.OR}}, \code{\link{df.RR}}, \code{\link{df.HR}} and \code{\link{df.IRR}}).
\subsection{Overall format}{

Information on a each individual study must be indicated in an unique row: if a meta-analysis included in an umbrella review includes 34 effect sizes, this meta-analysis should have 34 rows in the dataset.
We encourage users to include all the meta-analyses of their umbrella review in a single dataset so that calculations can be performed automatically for all the meta-analyses.
}

\subsection{Mandatory variables}{

The following variables should be included in the dataset regardless of the measure used.
The name of these variables (in bold) cannot be changed.
\itemize{
\item \bold{meta_review}: a character variable that contains an identifier for the sources of the meta-analyses included in an umbrella review.
\item \bold{factor}: a character variable that contains an identifier for the risk factors or the interventions whose effect is studied.
All rows in the dataset with the same factor value will be pooled together in a meta-analysis.
\item \bold{author} and \bold{year}: character variables identifying the name and the year of publication of each individual study that is included in a meta-analysis.
For a given factor, all rows with the same author and year value will be identified as having some type of dependence (see below).
\item \bold{measure}: a character variable describing the type of effect size measure used to quantify the effect of the factor and it must be either "SMD", "MD", "G", "OR", "logOR", "RR", "logRR", "HR", "logHR", "IRR" or "logIRR".
Note here that if a study reports the numbers of cases and controls in exposed and non-exposed groups but does not report an effect size value (i.e., the value of an OR or RR), we recommend specifying "OR" for case-control studies while "RR" for cohort studies.
}
}

\subsection{Required information depending on the effect size measure}{

Depending on the effect size measure used, different information must be provided to replicate the meta-analysis.
To allow users adapting to the data available in the articles, several combinations of information can be provided for a given effect size measure.
We detail the information that should be provided in the dataset and we provide several summary tables displaying the various combinations of minimum information required to run the analyses.

\itemize{
\item \bold{value}: Value of the effect size for each individual study.
\item \bold{ci_lo}: Lower bound of the 95\% confidence interval around the effect size for each individual study.
\item \bold{ci_up}: Upper bound of the 95\% confidence interval around the effect size for each individual study.
\item \bold{n_cases}: Number of cases included in each individual study.
\item \bold{n_controls}: Number of controls included in each individual study.
\item \bold{n_exp}: Number of exposed participants in each individual study.
\item \bold{n_nexp}: Number of non-exposed participants included in each individual study.
\item \bold{n_cases_exp}: Number of cases in the exposed group included in each individual study.
\item \bold{n_controls_exp}: Number of controls in the exposed group included in each individual study.
\item \bold{n_cases_nexp}: Number of cases in the non-exposed group included in each individual study.
\item \bold{n_controls_nexp}: Number of controls in the non-exposed group included in each individual study.
\item \bold{mean_cases}: Mean of the cases for each individual study.
\item \bold{mean_controls}: Mean of the controls for each individual study.
\item \bold{sd_cases}: Standard deviation of the cases for each individual study.
\item \bold{sd_controls}: Standard deviation of the controls for each individual study.
\item \bold{time_exp}: Sum of the person-time of disease-free observation time in the exposed and non-exposed groups for each individual study.
\item \bold{time_exp}: Person-time of disease-free observation time in the exposed group for each individual study.
\item \bold{time_nexp}: Person-time of disease-free observation time in the non-exposed group for each individual study.
}

We now present the tables indicating the minimum combination of information that should be provided for each individual study to run the analyses
The "X" indicates that this information is present in the dataset.
The symbol + between two information indicates that the two information are mandatory.
The symbol | between two information indicates that only one of the two information is required.
For each measure, you must provide information on at least one row of the table corresponding to the measure used.
Note that you can provide different combination of information for a same factor (e.g., you can have the SMD value + 95\% CI along with sample sizes for a study and the means/SD along with sample sizes for another study within the same factor). \cr
\subsection{\bold{1. SMD}}{\tabular{ccccc}{
   \code{mean_cases} + \code{mean_controls} +\cr \code{sd_cases} + \code{sd_controls} \tab \code{n_cases + n_controls} \tab \code{value} \tab \code{se | var} \tab \code{ci_lo + ci_up} \cr
   X \tab X \tab \emph{-} \tab \emph{-} \tab \emph{-} \cr
   \emph{-} \tab X \tab X \tab \emph{-} \tab \emph{-} \cr
   \emph{-} \tab X \tab X \tab X \tab \emph{-} \cr
   \emph{-} \tab X \tab X \tab \emph{-} \tab X \cr
}

}

\subsection{\bold{2. G}}{\tabular{cccc}{
   \code{n_cases + n_controls} \tab \code{value} \tab \code{se | var} \tab \code{ci_lo + ci_up} \cr
   X \tab X \tab \emph{-} \tab \emph{-} \cr
   X \tab X \tab X \tab \emph{-} \cr
   X \tab X \tab \emph{-} \tab X \cr
}

}

\subsection{\bold{3. MD}}{\tabular{cccc}{
   \code{n_cases + n_controls} \tab \code{value} \tab \code{se | var} \tab \code{ci_lo + ci_up} \cr
   X \tab X \tab X \tab \emph{-} \cr
   X \tab X \tab \emph{-} \tab X \cr
}

}

\subsection{\bold{4. OR or logOR}}{\tabular{cccccc}{
   \code{n_cases_exp} +\cr \code{n_controls_exp} +\cr \code{n_cases_nexp} +\cr \code{n_controls_nexp} \tab \code{n_exp} + \code{n_nexp} \tab \code{n_cases} + \code{n_controls} \tab \code{value} \tab \code{se | var} \tab \code{ci_lo} + \code{ci_up} \cr
   X \tab \emph{-} \tab \emph{-} \tab \emph{-} \tab \emph{-} \tab \emph{-} \cr
   \emph{-} \tab \emph{-} \tab X \tab X \tab \emph{-} \tab \emph{-} \cr
   \emph{-} \tab \emph{-} \tab X \tab X \tab X \tab \emph{-} \cr
   \emph{-} \tab \emph{-} \tab X \tab X \tab \emph{-} \tab X \cr
   \emph{-} \tab X \tab \emph{-} \tab X \tab X \tab \emph{-} \cr
   \emph{-} \tab X \tab \emph{-} \tab X \tab \emph{-} \tab X \cr
}

}

\subsection{\bold{5. RR or logRR}}{\tabular{ccccc}{
   \code{n_cases_exp} + \code{n_controls_exp} +\cr \code{n_cases_nexp} + \code{n_controls_nexp} \tab \code{n_cases} + \code{n_controls} \tab \code{value} \tab \code{se | var} \tab \code{ci_lo} + \code{ci_up} \cr
   X \tab \emph{-} \tab \emph{-} \tab \emph{-} \tab \emph{-} \cr
   \emph{-} \tab X \tab X \tab X \tab \emph{-} \cr
   \emph{-} \tab X \tab X \tab \emph{-} \tab X \cr
}

}

\subsection{\bold{6. HR or logHR}}{\tabular{cccc}{
   \code{n_cases} + \code{n_controls} \tab \code{value} \tab \code{se | var} \tab \code{ci_lo} + \code{ci_up} \cr
   X \tab X \tab X \tab \emph{-} \cr
   X \tab X \tab \emph{-} \tab X \cr
}

}

\subsection{\bold{7. IRR or logIRR}}{\tabular{cccccc}{
   \code{n_cases_exp} + \code{n_cases_nexp} +\cr\code{time_exp} + \code{time_nexp} \tab \code{n_cases} \tab \code{time} \tab \code{value} \tab \code{se | var} \tab \code{ci_lo} + \code{ci_up} \cr
   X \tab \emph{-} \tab \emph{-} \tab \emph{-} \tab \emph{-} \tab \emph{-} \cr
   \emph{-} \tab X \tab X \tab X \tab X \tab \emph{-} \cr
   \emph{-} \tab X \tab X \tab X \tab \emph{-} \tab X \cr
}

}

}

\subsection{Optional variables}{

The following variables should not necessarily be included in the dataset but can be added to benefit from certain features of the functions.
The name of these variables (in bold) cannot be changed.
\itemize{
\item \bold{multiple_es}: Reason for the presence of several effect sizes for a unique study (i.e., a study with the same author and year values within the same factor).
It must be either "groups" or "outcomes". An example of a dataset with multiple outcomes/groups can be found here (\code{\link{df.OR.multi}}) and an example
of analysis of a dataset with dependent effect sizes is available in a vignette of the package.
\item \code{groups}: When "groups" is indicated, it is assumed that the multiple effect sizes for a unique study come from independent subgroups.
A unique effect size per study is calculated using the Borenstein's (2009) approach.
For each study, the sample size is obtained by summing up all participants from the different groups. \cr
An example of a dataset with multiple groups can be found here (\code{\link{df.OR.multi}}).
\item \code{outcomes}: When "outcomes" is indicated, it is assumed that the multiple effect sizes come from multiple outcomes (or time-points) measured within the same sample.
Again, a unique effect size per study is calculated using the Borenstein's (2009) approach.
Strength of the correlation between the outcomes (or time-points) can be indicated using either a \code{r} column in your dataset (see below) or the \code{r} argument of the \code{\link{umbrella}()} function.
Indicating the strength of the correlation between the outcomes of a study in the \code{r} column allows to use different values depending on the study.
In contrast, using the \code{r} argument of \code{\link{umbrella}()} function allows to conveniently set a unique correlation for all studies that do not have any value in the \code{r} column .
For each study, the sample size is obtained by taking the largest sample size assessed in one outcome.\cr
\item \bold{r}: The value of the correlation coefficient between the outcomes of a study.
The r value should be (i) within the (-1, 1) range, (ii) constant within a study, and (iii) set as \code{NA} for studies which do not include multiple outcomes.
\item \bold{shared_nexp}: In some situations, several studies share participants from the same non-exposed group but compare it to various exposed groups.
When several studies in the same factor share a same non-exposed group, they should be identified as such by having the same \code{shared_nexp} value. Identifying studies sharing the same non-exposed group allows to adjust calculations (the size of the shared sample is divided by the number of studies sharing the sample).
Studies not sharing their non-exposed group should have a NA (or a unique) value in the \code{shared_nexp} column.
\item \bold{shared_controls}: In some situations, several studies share participants from the same control group but compare it to various experimental groups.
When several studies in the same factor share a same control group, they should be identified as such by having the same \code{shared_control} value. Identifying studies sharing the same control group allows to adjust calculations (the size of the shared sample is divided by the number of studies sharing the sample).
Studies not sharing their control group should have a NA (or a unique) value in the \code{shared_controls} column.
\item \bold{reverse_es}: Whether you want to reverse the effect size of a study. All rows with a \code{"reverse"} value in this column will have the direction of their effect size flipped (e.g., an OR of 0.5 will be expressed as 2). Note that the reverse_es column has an action on both the direction of the value of an effect size and on the information used to calculate an effect size
(e.g., if the means and SDs of experimental and control groups are reported, the mean and SD of the experimental group are used as the mean and SD of the control group and vice-versa).
This feature is particularly useful to facilitate the presentation of the results when several meta-analyses report the same effects in opposite direction.
\item \bold{rob}: The risk of bias of each individual study. Should be either "high", "low" or "unclear". These values are used to generate the "GRADE" classification and to stratify evidence according to the 'rob' criteria in the 'Personalized' classification
Studies with a missing rob are assumed to be at high risk of bias. The approach used to provide a categorical judgment ("low" vs. "unclear" vs. "high) on the risk of bias of a study is left to the user.
\item \bold{amstar}: The amstar score of the meta-analysis. Note that the amstar score should be constant for a given factor.
These values are used only to stratify evidence according to the 'amstar' criteria in the 'Personalized' classification
\item \bold{analysis}: Whether users want to conduct specific analyses. For now, only the "allelic" value can be specified, which multiplies by two the number of cases and controls.
\item \bold{discard}: Whether a particular row should be removed from the analyses (any row with a "yes" or TRUE value in the \code{discard} column will be removed).
}
}
}

