% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_fns_list.R
\name{dist_fns}
\alias{dist_fns}
\alias{euclidean_distance}
\alias{gower_distance}
\alias{sn_euclidean_distance}
\alias{sew_euclidean_distance}
\alias{hamming_distance}
\title{Built-in distance functions}
\usage{
euclidean_distance(df, weights_row)

gower_distance(df, weights_row)

sn_euclidean_distance(df, weights_row)

sew_euclidean_distance(df, weights_row)

hamming_distance(df, weights_row)
}
\arguments{
\item{df}{Data frame containing at least 1 data column}

\item{weights_row}{Single-row data frame where the column names contain the
column names in df and the row contains the corresponding weights_row.}
}
\value{
A matrix class object containing pairwise distances.
}
\description{
These functions can be used when building a \code{metasnf} distance functions
list. Each function converts a data frame into to a distance matrix.
}
\details{
Functions that work for numeric data:
\itemize{
\item euclidean_distance: typical Euclidean distance
\item sn_euclidean_distance: Data frame is first standardized and normalized
before typical Euclidean distance is applied
\item siw_euclidean_distance: Squared (including weights) Euclidean distance,
where the weights are also squared
\item sew_euclidean_distance: Squared (excluding weights) Euclidean distance,
where the weights are not also squared
}

Functions that work for binary data:
\itemize{
\item hamming_distance: typical Hamming distance
}

Functions that work for any type of data:
\itemize{
\item gower_distance: Gower distance (cluster::daisy)
}
}
