% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_cluster.R
\name{calc_aris}
\alias{calc_aris}
\title{Meta-cluster calculations}
\usage{
calc_aris(solutions_matrix, processes = 1, verbose = FALSE)
}
\arguments{
\item{solutions_matrix}{solutions_matrix containing cluster solutions to
calculate pairwise ARIs for.}

\item{processes}{Specify number of processes used to complete calculations
\itemize{
\item \code{1} (default) Sequential processing
\item \code{2} or higher: Parallel processing will use the
\code{future.apply::future_apply} to distribute the calculations across
the specified number of CPU cores. If higher than the number of
available cores, a warning will be printed and the maximum number of
cores will be used.
\item \code{max}: All available cores will be used.
Note that no progress indicator is available during multi-core processing.
}}

\item{verbose}{If TRUE, print progress to console.}
}
\value{
om_aris ARIs between clustering solutions of an solutions matrix
}
\description{
Generate matrix of pairwise cluster-solution similarities by Adjusted Rand
index calculations.
}
