% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density.R
\name{densplot_data_frame}
\alias{densplot_data_frame}
\title{Density Function for Data Frame}
\usage{
densplot_data_frame(x, xvar, groups = NULL, facets = NULL,
  xlab = metOption("xlab_dens", "axislabel"), ref = metOption("ref_x_dens",
  "metaplot_ref"), ref.col = metOption("ref_col_dens", "grey"),
  ref.lty = metOption("ref_lty_dens", "solid"),
  ref.lwd = metOption("ref_lwd_dens", 1),
  ref.alpha = metOption("ref_alpha_dens", 1), log = metOption("log_dens",
  FALSE), crit = metOption("crit_dens", 1.3),
  aspect = metOption("aspect_dens", 1), scales = metOption("scales_dens",
  NULL), panel = metOption("panel_dens", "dens_panel"),
  points = metOption("points_dens", TRUE), colors = metOption("colors_dens",
  NULL), symbols = metOption("symbols_dens", NULL),
  sizes = metOption("sizes_dens", 1), lines = metOption("lines_dens", TRUE),
  types = metOption("types_dens", "solid"),
  widths = metOption("widths_dens", 1), fill = metOption("fill_dens",
  FALSE), space = metOption("space_dens", "right"),
  key = metOption("key_dens", "metaplot_key"),
  as.table = metOption("as.table_dens", TRUE), main = metOption("main_dens",
  NULL), sub = metOption("sub_dens", NULL),
  settings = metOption("settings_dens", NULL),
  padding = metOption("padding_dens", 1), gg = metOption("gg_dens", FALSE),
  verbose = metOption("verbose_dens", FALSE), ...)
}
\arguments{
\item{x}{data.frame}

\item{xvar}{variable to plot}

\item{groups}{optional grouping variable}

\item{facets}{optional conditioning variables}

\item{xlab}{x axis label; can be function(x = x, var = xvar, log = log, ...)}

\item{ref}{reference line; can be function(x = x, var = xvar, ...) or NULL to suppress}

\item{ref.col}{color for reference line(s); can be length one integer to auto-select that many colors}

\item{ref.lty}{type for reference line(s)}

\item{ref.lwd}{size for reference line(s)}

\item{ref.alpha}{transparency for reference line(s)}

\item{log}{whether to log-transform x axis (auto-selected if NA)}

\item{crit}{if log is NA, log-transform if mean/median ratio for non-missing x is greater than this value (and no negative values)}

\item{aspect}{passed to \code{\link[lattice]{bwplot}} or ggplot; use 'fill', NA, or NULL to calculate automatically}

\item{scales}{passed to \code{\link[lattice]{xyplot}} or \code{\link[ggplot2]{facet_grid}} or \code{\link[ggplot2]{facet_wrap}} (guessed if NULL)}

\item{panel}{passed to \code{\link[lattice]{densityplot}}}

\item{points}{whether to plot points: logical or alpha, same length as groups}

\item{colors}{replacements for default colors in group order; can be length one integer to auto-select that many colors}

\item{symbols}{replacements for default symbols in group order}

\item{sizes}{replacements for default symbol sizes in group order}

\item{lines}{whether to plot lines: logical or alpha, same length as groups}

\item{types}{replacements for default line types in group order}

\item{widths}{replacements for default line widths in group order}

\item{fill}{whether to fill curves: logical or alpha, same length as groups (symbol fill color is same as point color)}

\item{space}{location of key (right, left, top, bottom)}

\item{key}{list: passed to \code{\link[lattice]{xyplot}} as \code{auto.key} or to \code{\link[ggplot2]{theme}}; can be a function groups name, groups levels, points, lines, space, gg, and \dots .  See \code{\link{metaplot_key}}.}

\item{as.table}{passed to \code{\link[lattice]{xyplot}}}

\item{main}{character, or a function of x, xvar, groups, facets, and log}

\item{sub}{character, or a function of x, xvar, groups, facets, and log}

\item{settings}{default parameter settings: a list from which matching elements are passed to lattice (as par.settings) or  to ggplot theme()  and facet_wrap() or facet_grid().  \code{ncol} and \code{nrow} are used as layout indices for lattice (for homology with facet_wrap).}

\item{padding}{numeric (will be recycled to length 4) giving plot margins in default units: top, right, bottom, left (in multiples of 5.5 points for ggplot)}

\item{gg}{logical: whether to generate \code{ggplot} instead of \code{trellis}}

\item{verbose}{generate messages describing process}

\item{...}{passed to \code{\link[lattice]{densityplot}}}
}
\description{
Plot density for object of class 'data.frame' using \code{dens_panel} by default.
}
\examples{
densplot_data_frame(Theoph, 'conc', grid = TRUE)
densplot_data_frame(Theoph, 'conc', 'Subject')
densplot_data_frame(Theoph, 'conc', 'Subject',
space = 'top', columns = 4, legend.direction = 'horizontal')
densplot_data_frame(Theoph, 'conc', 'Subject',
space = 'top', columns = 4, legend.direction = 'horizontal', gg = TRUE)
densplot_data_frame(Theoph, 'conc', , 'Subject')
}
\seealso{
Other univariate plots: \code{\link{dens_panel}},
  \code{\link{densplot.data.frame}},
  \code{\link{densplot}},
  \code{\link{metaplot.data.frame}},
  \code{\link{panel.meta_densityplot}}

Other densplot: \code{\link{densplot.data.frame}},
  \code{\link{densplot}}

Other metaplot: \code{\link{boxplot_data_frame}},
  \code{\link{categorical_data_frame}},
  \code{\link{corsplom_data_frame}},
  \code{\link{metaplot_key}}, \code{\link{metaplot}},
  \code{\link{scatter_data_frame}},
  \code{\link{test_metaplot}}
}
