% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{corsplom_panel_diagonal}
\alias{corsplom_panel_diagonal}
\title{Diagonal Panel Function for Metaplot Corsplom}
\usage{
corsplom_panel_diagonal(x, varname, .data, density = TRUE,
  diag.label = metOption("diag_label_corsplom_panel", diag_label),
  pin = metOption("pin_loc_corsplom_panel", diag_pin),
  pin.col = metOption("pin_col_corsplom_panel", "darkgrey"),
  pin.alpha = metOption("pin_alpha_corsplom_panel", 1),
  dens.col = metOption("dens_col_corsplom_panel", "grey"),
  dens.scale = metOption("dens_scale_corsplom_panel", 0.2),
  dens.alpha = metOption("dens_alpha_corsplom_panel", 0.5),
  as.table = metOption("as.table_corsplom_panel", FALSE),
  dens.up = metOption("densup_corsplom_panel", TRUE),
  verbose = metOption("verbose_corsplom_panel", FALSE), ...)
}
\arguments{
\item{x}{numeric}

\item{varname}{variable name}

\item{.data}{copy of original dataset}

\item{density}{whether to plot density polygons}

\item{diag.label}{label for the diagonal; can be a function of x, varname, .data}

\item{pin}{location for a pin (reference line) in the density region; can be a function of x, varname, .data}

\item{pin.col}{color of pin, if any}

\item{pin.alpha}{alpha transparency of pin}

\item{dens.col}{color for density region}

\item{dens.scale}{inflation factor for height of density smooth}

\item{dens.alpha}{alpha transparency for density region}

\item{as.table}{diagonal arranged top-left to bottom-right}

\item{dens.up}{whether density plots should face the upper triangle (or lower, if FALSE)}

\item{verbose}{generate messages describing process}

\item{...}{passed arguments}
}
\description{
Default diagonal panel function for corsplom_data_frame. Plots a density smooth against the corresponding axis from within the diagonal panel.  Plots a grey pin at each axis zero.
}
\seealso{
\code{\link{corsplom}}

Other panel functions: \code{\link{boxplot_panel}},
  \code{\link{categorical_panel}},
  \code{\link{corsplom_gg_correlation}},
  \code{\link{corsplom_gg_diagonal}},
  \code{\link{corsplom_gg_scatter}},
  \code{\link{corsplom_panel_correlation}},
  \code{\link{corsplom_panel_scatter}},
  \code{\link{dens_panel}}, \code{\link{diag_label}},
  \code{\link{diag_pin}}, \code{\link{iso_prepanel}},
  \code{\link{metaplot_key}}, \code{\link{metaplot_ref}},
  \code{\link{panel.meta_densityplot}},
  \code{\link{panel_tile}},
  \code{\link{scatter_panel_ref}},
  \code{\link{scatter_panel}}
}
\keyword{internal}
