% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter.R
\name{scatter_panel}
\alias{scatter_panel}
\title{Panel Function for Metaplot Scatterplot}
\usage{
scatter_panel(x, y, groups, xref = getOption("scatter_panel_ref",
  scatter_panel_ref), yref = getOption("scatter_panel_ref",
  scatter_panel_ref), ref.col = getOption("metaplot_ref.col", "grey"),
  ref.lty = getOption("metaplot_ref.lty", "solid"),
  ref.alpha = getOption("metaplot_ref.alpha", 1),
  ysmooth = getOption("metaplot_ysmooth", FALSE),
  xsmooth = getOption("metaplot_xsmooth", FALSE),
  smooth.lty = getOption("metaplot_smooth.lty", "dashed"),
  smooth.alpha = getOption("metaplot_smooth.alpha", 1),
  fit = getOption("metaplot_fit", conf),
  fit.lty = getOption("metaplot_fit.lty", "solid"),
  fit.alpha = getOption("metaplot_fit.alpha", 1),
  conf = getOption("metaplot_conf", FALSE),
  conf.alpha = getOption("metaplot_conf.alpha", 0.3),
  loc = getOption("metaplot_loc", 0), iso = getOption("metaplot_iso",
  FALSE), global = getOption("metaplot_global", FALSE),
  global.col = getOption("metaplot_global.col", "grey"),
  msg = getOption("metaplot_msg", "metastats"), type, ...)
}
\arguments{
\item{x}{x values}

\item{y}{y values}

\item{groups}{optional grouping item}

\item{xref}{reference line from x axis; can be function(x, y, ...)}

\item{yref}{reference line from y axis; can be function(y, x, ...)}

\item{ref.col}{reference line color}

\item{ref.lty}{reference line type}

\item{ref.alpha}{reference line alpha}

\item{ysmooth}{supply loess smooth of y on x}

\item{xsmooth}{supply loess smmoth of x on y}

\item{smooth.lty}{smooth line type}

\item{smooth.alpha}{smooth alpha}

\item{fit}{draw a linear fit of y ~ x}

\item{fit.lty}{fit line type}

\item{fit.alpha}{fit alpha}

\item{conf}{logical, or width for a confidence region around a linear fit; passed to \code{\link{region}}; \code{TRUE} defaults to 95 percent confidence interval; may not make sense if xlog is TRUE}

\item{conf.alpha}{alpha transparency for confidence region}

\item{loc}{where to print statistics on a panel; suppressed for grouped plots}

\item{iso}{use isometric axes with line of unity (auto-selected if NA)}

\item{global}{if TRUE, xsmooth, ysmooth, fit, and conf are applied to all data rather than groupwise}

\item{global.col}{color for global aesthetics}

\item{msg}{a function to print text on a panel: called with x values, y values, and \dots.}

\item{type}{overridden by scatter_panel}

\item{...}{passed to panel.superpose, panel.xyplot, panel.polygon, region, panel.text}
}
\description{
Default panel function for scatter_data_frame. Calls \code{\link[lattice]{panel.xyplot}} and optionally plots linear fit, confidence region, reference lines, and statistics.
}
\seealso{
\code{\link{metastats}}

\code{\link{scatter.data.frame}}

Other panel functions: \code{\link{boxplot_panel}},
  \code{\link{corsplom_panel_correlation}},
  \code{\link{corsplom_panel_diagonal}},
  \code{\link{corsplom_panel_scatter}},
  \code{\link{dens_panel}}, \code{\link{diag_label}},
  \code{\link{diag_pin}}, \code{\link{iso_prepanel}},
  \code{\link{metaplot_ref}},
  \code{\link{scatter_panel_ref}}

Other scatter: \code{\link{scatter.data.frame}},
  \code{\link{scatter_data_frame}}, \code{\link{scatter}}
}
