% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pack.R
\name{pack.data.frame}
\alias{pack.data.frame}
\title{Capture Scalar Column Metadata as Column Attributes}
\usage{
\method{pack}{data.frame}(x, meta = getOption("meta", "meta"), as.is = TRUE,
  ...)
}
\arguments{
\item{x}{data.frame}

\item{meta}{column in x giving names of attributes}

\item{as.is}{passed to \code{\link[utils]{read.table}}}

\item{...}{ignored arguments}
}
\value{
data.frame
}
\description{
Captures scalar column metadata (row values) as column attributes.  Excises rows with non-missing values of \code{meta}, converting column values to column attributes. Afterward, column classes are re-optimized using default behavior of \code{read.table}. It is an error if \code{meta} is not in \code{names(x)}.
}
\examples{
foo <- data.frame(head(Theoph))
attr(foo$Subject, 'label') <-  'subject identifier'
attr(foo$Wt, 'label') <-  'weight'
attr(foo$Dose, 'label') <-  'dose'
attr(foo$Time, 'label') <-  'time'
attr(foo$conc, 'label') <-  'concentration'
attr(foo$Subject, 'guide') <-  '////'
attr(foo$Wt, 'guide') <-  'kg'
attr(foo$Dose, 'guide') <-  'mg/kg'
attr(foo$Time, 'guide') <-  'h'
attr(foo$conc, 'guide') <-  'mg/L'
unpack(foo, pos = 1)
unpack(foo, pos = 2)
unpack(foo, pos = 3)
unpack(foo, pos = 4)
bar <- unpack(foo)
pack(bar)
attributes(pack(bar)$Subject)
}
\seealso{
Other pack: \code{\link{unpack.data.frame}},
  \code{\link{unpack}}
}
