% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{plot.clustering}
\alias{plot.clustering}
\title{Plot an object of class clustering}
\usage{
\method{plot}{clustering}(x, horiz = TRUE, type = "dendrogram", ...)
}
\arguments{
\item{x}{An object of class \code{clustering}}

\item{horiz}{Logical indicating if the dendrogram should be drawn
horizontally or not.}

\item{type}{The type of plot. Must be one of the 'dendrogram' or
'cophenetic'.}

\item{...}{Other arguments passed from the function \code{plot.dendrogram} or
\code{abline}.}
}
\value{
An object of class \verb{gg, ggplot} if \code{type == "cophenetic"}.
}
\description{
Plot an object of class clustering
}
\examples{
\donttest{
mean_gen <-
 data_ge2 \%>\%
 mean_by(GEN) \%>\%
 column_to_rownames("GEN")

d <- clustering(mean_gen)
plot(d, xlab = "Euclidean Distance")
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
