% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residual_plots.R
\name{residual_plots}
\alias{residual_plots}
\title{Several types of residual plots}
\usage{
residual_plots(
  x,
  var = 1,
  conf = 0.95,
  labels = FALSE,
  plot_theme = theme_metan(),
  band.alpha = 0.2,
  point.alpha = 0.8,
  fill.hist = "gray",
  col.hist = "black",
  col.point = "black",
  col.line = "red",
  col.lab.out = "red",
  size.lab.out = 2.5,
  size.tex.lab = 10,
  size.shape = 1.5,
  bins = 30,
  which = c(1:4),
  ncol = NULL,
  nrow = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{performs_ammi}, \code{waas},
\code{anova_joint}, or  \code{gafem}}

\item{var}{The variable to plot. Defaults to \code{var = 1} the first
variable of \code{x}.}

\item{conf}{Level of confidence interval to use in the Q-Q plot (0.95 by
default).}

\item{labels}{Logical argument. If \code{TRUE} labels the points outside
confidence interval limits.}

\item{plot_theme}{The graphical theme of the plot. Default is
\code{plot_theme = theme_metan()}. For more details, see
\code{\link[ggplot2:theme]{ggplot2::theme()}}.}

\item{band.alpha, point.alpha}{The transparency of confidence band in the Q-Q
plot and the points, respectively. Must be a number between 0 (opaque) and
1 (full transparency).}

\item{fill.hist}{The color to fill the histogram. Default is 'gray'.}

\item{col.hist}{The color of the border of the the histogram. Default is
'black'.}

\item{col.point}{The color of the points in the graphic. Default is 'black'.}

\item{col.line}{The color of the lines in the graphic. Default is 'red'.}

\item{col.lab.out}{The color of the labels for the 'outlying' points.}

\item{size.lab.out}{The size of the labels for the 'outlying' points.}

\item{size.tex.lab}{The size of the text in axis text and labels.}

\item{size.shape}{The size of the shape in the plots.}

\item{bins}{The number of bins to use in the histogram. Default is 30.}

\item{which}{Which graphics should be plotted. Default is \code{which = c(1:4)} that means that the first four graphics will be plotted.}

\item{ncol, nrow}{The number of columns and rows of the plot pannel. Defaults
to \code{NULL}}

\item{...}{Additional arguments passed on to the function
\code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Residual plots for a output model of class \code{performs_ammi},
\code{waas},  \code{anova_ind}, and  \code{anova_joint}. Seven types of plots
are produced: (1) Residuals vs fitted, (2) normal Q-Q plot for the residuals,
(3) scale-location plot (standardized residuals vs Fitted Values), (4)
standardized residuals vs Factor-levels, (5) Histogram of raw residuals and
(6) standardized residuals vs observation order, and (7) 1:1 line plot
}
\examples{
\donttest{
library(metan)
model <- performs_ammi(data_ge, ENV, GEN, REP, GY)

# Default plot
plot(model)

# Normal Q-Q plot
# Label possible outliers
plot(model,
     which = 2,
     labels = TRUE)

# Residual vs fitted,
# Normal Q-Q plot
# Histogram of raw residuals
# All in one row
plot(model,
     which = c(1, 2, 5),
     nrow = 1)
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
