% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ge_polar.R
\name{ge_polar}
\alias{ge_polar}
\title{Power Law Residuals as yield stability index
\loadmathjax}
\usage{
ge_polar(.data, env, gen, resp, base = 10, verbose = TRUE)
}
\arguments{
\item{.data}{The dataset containing the columns related to Environments,
Genotypes and response variable(s).}

\item{env}{The name of the column that contains the levels of the
environments.}

\item{gen}{The name of the column that contains the levels of the genotypes.}

\item{resp}{The response variable(s). To analyze multiple variables in a
single procedure use, for example, \code{resp = c(var1, var2, var3)}.}

\item{base}{The base with respect to which logarithms are computed. Defaults
to \code{10}.}

\item{verbose}{Logical argument. If \code{verbose = FALSE} the code will run
silently.}
}
\value{
An object of class \code{ge_acv}, which is a list containing the
results for each variable used in the argument \code{resp}. For each
variable, a tibble with the following columns is returned.
\itemize{
\item \strong{GEN} the genotype's code.
\item \strong{POLAR} The Power Law Residuals
\item \strong{POLAR_R} The rank for the ACV value.
}
}
\description{
Performs a stability analysis based on the Power Law Residuals
(POLAR) statistics (Doring et al., 2015). POLAR is the residuals from the
linear regression of \mjseqn{log(\sigma^2}) against \mjseqn{log(\mu}) and
can be used as a measure of crop stability with lower stability (relative
to all samples with that mean yield) indicated by more positive POLAR
values, and higher stability (relative to all samples with that mean yield)
indicated by more negative POLAR values.
}
\examples{
\donttest{
library(metan)
out <- ge_polar(data_ge2, ENV, GEN, c(EH, PH, EL, CD, ED, NKE))
gmd(out)
}

}
\references{
Doring, T.F., S. Knapp, and J.E. Cohen. 2015. Taylor's power law
and the stability of crop yields. F. Crop. Res. 183: 294-302.
\doi{10.1016/j.fcr.2015.08.005}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
