% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{transform_power}
\alias{transform_power}
\title{Transforms the intensities by calculating their \emph{n}th root}
\usage{
transform_power(data, n = 2)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}

\item{n}{The \emph{n}th root to calculate.}
}
\value{
A tibble with power-transformed intensities.
}
\description{
Calculates the \emph{n}th root of intensities with x^(1/n). The default (n = 2) calculates the square root.
This transformation can help reduce heteroscedasticity. See references for more information.
}
\examples{
toy_metaboscape \%>\%
  impute_lod() \%>\%
  transform_power()
}
\references{
\itemize{
\item R. A. Van Den Berg, H. C. Hoefsloot, J. A. Westerhuis, A. K. Smilde, M. J. Van Der Werf, \emph{BMC Genomics} \strong{2006}, \emph{7}, 142, DOI 10.1186/1471-2164-7-142.
}
}
