% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_neutral_loss}
\alias{filter_neutral_loss}
\title{Filter Features based on occurrence of neutral losses}
\usage{
filter_neutral_loss(
  data,
  losses,
  min_found,
  tolerance = 10,
  tolerance_type = "ppm",
  show_progress = TRUE
)
}
\arguments{
\item{data}{A data frame containing MSn spectra.}

\item{losses}{A numeric. Exact mass of the fragment(s) to filter by.}

\item{min_found}{How many of the \code{fragments} must be found in order to keep the row? If \code{min_found = length(fragments)}, all fragments must be found.}

\item{tolerance}{A numeric. The tolerance to apply to the fragments. Either an absolute value in Da (if \code{tolerance_type = "absolute"}) or in ppm (if \code{tolerance_type = "ppm"}).}

\item{tolerance_type}{Either \code{"absolute"} or \code{"ppm"}. Should the tolerance be an absolute value or in ppm?}

\item{show_progress}{A \code{logical} indicating whether the progress of the filtering should be printed to the console. Only important for large tibbles.}
}
\value{
A filtered tibble.
}
\description{
The occurrence of characteristic neutral losses can help with the putative annotation of molecules. See the Reference section for an example.
}
\examples{
# neutral losses must be calculated first
toy_mgf_nl <- toy_mgf \%>\%
  calc_neutral_loss(m_z_col = PEPMASS)

# all of the given losses (3) must be found
# returns the first row of toy_mgf
toy_mgf_nl \%>\%
  filter_neutral_loss(losses = c(11.1111, 22.2222, 33.3333), min_found = 3)

# all of the given fragments (3) must be found
# returns an empty tibble because the third loss
# of row 1 (33.3333)
# is outside of the tolerance (10 ppm):
# Lower bound:
# 33.4333 - 33.4333 * 5 / 1000000 = 33.4333
# Upper bound:
# 33.4333 + 33.4333 * 5 / 1000000 = 33.4336
toy_mgf_nl \%>\%
  filter_neutral_loss(losses = c(11.1111, 22.2222, 33.4333), min_found = 3)

# only 2 of the 3 fragments must be found
# returns the first row of toy_mgf
toy_mgf_nl \%>\%
  filter_neutral_loss(losses = c(11.1111, 22.2222, 33.4333), min_found = 2)
}
\references{
\itemize{
\item A. Brink, F. Fontaine, M. Marschmann, B. Steinhuber, E. N. Cece, I. Zamora, A. Pähler, \emph{Rapid Commun. Mass Spectrom.} \strong{2014}, \emph{28}, 2695–2703, DOI 10.1002/rcm.7062.
}
}
