% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_blank}
\alias{filter_blank}
\title{Filter Features based on their occurrence in blank samples}
\usage{
filter_blank(
  data,
  blank_samples,
  min_frac = 3,
  blank_as_group = FALSE,
  group_column = NULL
)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}

\item{blank_samples}{Defines the blanks. If \code{blank_as_group = FALSE} a character vector containing the names of the blank samples
as in the \code{Sample} column of \code{data}. If \code{blank_as_group = TRUE} the name(s) of the group(s) that define blanks, as in the \code{Group} column of \code{data}.
The latter can only be used if sample metadata is provided.}

\item{min_frac}{A numeric defining how many times higher the maximum intensity in samples must be in relation to blanks.}

\item{blank_as_group}{A logical indicating if \code{blank_samples} are the names of samples or group(s).}

\item{group_column}{Only relevant if \code{blank_as_group = TRUE}. Which column should be used for grouping blank and non-blank samples? Usually \code{group_column = Group}. Uses \code{\link[rlang]{args_data_masking}}.}
}
\value{
A filtered tibble.
}
\description{
Filters Features based on their occurrence in blank samples.
For example, if \code{min_frac = 3} the maximum intensity in samples must be at least 3 times as high as in blanks
for a Feature not to be filtered out.
}
\examples{
# Example 1: Define blanks by sample name
toy_metaboscape \%>\%
  filter_blank(blank_samples = c("Blank1", "Blank2"), blank_as_group = FALSE, min_frac = 3)

# Example 2: Define blanks by group name
# toy_metaboscape \%>\%
#  join_metadata(toy_metaboscape_metadata) \%>\%
#  filter_blank(blank_samples = "blank",
#               blank_as_group = TRUE,
#               min_frac = 3,
#               group_column = Group)
}
